/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandlerProvider;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import icons.CidrLangIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewHeaderFileAction
extends OCNewFileWithSelectedExtensionAction<MyCreateFileDialog> {
    public OCNewHeaderFileAction() {
        super((FileType)OCNewFileLangBackendHandlerProvider.getHandler().getFileType(), CidrLangBundle.message("create.cpp.header.title", new Object[0]), CidrLangBundle.message("create.cpp.header.title", new Object[0]), CidrLangIcons.FileTypes.H);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        Pair<String, FileExtensionPair> nameAndExtension = this.determineNameAndExtension(selectedName, true);
        return new OCNewFileActionBase.NewFileNames(null, (String)nameAndExtension.first + "." + ((FileExtensionPair)nameAndExtension.second).myHeaderExt);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        Couple<String> couple = this.determineExtensions(sampleFile, null, StringUtil.nullize((String)FileUtilRt.getExtension((String)selectedName)));
        String newHeaderExtension = StringUtil.isNotEmpty((String)((String)couple.second)) ? "." + (String)couple.second : "";
        return new OCNewFileActionBase.NewFileNames(null, FileUtilRt.getNameWithoutExtension((String)selectedName) + newHeaderExtension);
    }

    @Override
    @Nullable
    protected String getFileTemplate(String fileName) {
        return OCNewHeaderFileAction.headerTemplate();
    }

    @NotNull
    public static String headerTemplate() {
        return "C Header File.h";
    }

    @Override
    protected boolean isValidName(@NotNull String selectedName) {
        if (StringUtil.isEmpty((String)FileUtilRt.getNameWithoutExtension((String)selectedName))) {
            return false;
        }
        String headerName = this.getNewFileNames(selectedName).getHeaderName();
        return headerName != null && super.isValidName(headerName) && !FileUtilRt.getExtension((String)headerName).isEmpty() && OCFileTypeHelpers.isHeaderFile(headerName);
    }

    @Override
    @NotNull
    protected MyCreateFileDialog createDialog(@NotNull @NlsContexts.Label String defaultName) {
        return new MyCreateFileDialog(defaultName, this.getHelpId());
    }

    protected class MyCreateFileDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        MyCreateFileDialog(@Nullable String defaultName, String helpId) {
            super(defaultName, helpId);
        }

        @Override
        @NotNull
        protected String getPresentableName(@NotNull FileExtensionPair pair) {
            return "." + pair.myHeaderExt;
        }
    }
}

