/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.application.options.CodeStyle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.ui.InplaceButton;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandlerProvider;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCFileExtensionsSettings;
import com.jetbrains.cidr.lang.settings.OCFileExtensionsSettingsProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCNewFileWithSelectedExtensionAction<T extends CreateFileDialog>
extends OCNewFileActionBase<T> {
    @NonNls
    private static final String NEW_CPP_HELP_TOPIC_ID = "New_CPP_File_Dialog";

    protected OCNewFileWithSelectedExtensionAction(@Nullable FileType type, @NlsActions.ActionText String text, @NlsActions.ActionDescription String description2, Icon icon) {
        super(type, text, description2, icon);
    }

    @NotNull
    protected List<FileExtensionPair> getExtensions(@NotNull Project project) {
        return ((OCFileExtensionsSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCFileExtensionsSettings.class)).FILE_EXTENSION_PAIRS_ORDERED;
    }

    @NotNull
    @NonNls
    protected String getHelpId() {
        return NEW_CPP_HELP_TOPIC_ID;
    }

    @NotNull
    protected Couple<String> determineExtensions(@NotNull PsiFile sampleFile, @Nullable String preferredSourceExt, @Nullable String preferredHeaderExt) {
        return OCNewFileLangBackendHandlerProvider.getHandler().determineExtensions(sampleFile, preferredSourceExt, preferredHeaderExt);
    }

    @NotNull
    protected Pair<String, FileExtensionPair> determineNameAndExtension(@NotNull String fileName, boolean isHeader) {
        String selectedExt = FileUtilRt.getExtension((String)fileName);
        FileExtensionPair extensionPair = null;
        OCNewFileActionBase.DisposableState state = this.getState();
        if (selectedExt.length() > 0 && (isHeader ? OCFileTypeHelpers.isHeaderFile(fileName) : OCFileTypeHelpers.isSourceFile(fileName))) {
            fileName = FileUtilRt.getNameWithoutExtension((String)fileName);
            if (state != null) {
                List<FileExtensionPair> es = this.getExtensions(state.project);
                for (FileExtensionPair e : es) {
                    String referenceExt = isHeader ? e.myHeaderExt : e.mySourceExt;
                    if (!referenceExt.equals(selectedExt)) continue;
                    extensionPair = e;
                    break;
                }
            }
            if (extensionPair == null) {
                String srcExt = isHeader ? "cpp" : selectedExt;
                String headerExt = isHeader ? selectedExt : "h";
                extensionPair = new FileExtensionPair(srcExt, headerExt, NamingConventionStyle.NONE);
            }
        } else {
            if (state != null) {
                extensionPair = ((CreateFileDialog)((Object)state.dialogPeer)).myFileExtensionPair;
            }
            if (extensionPair == null) {
                extensionPair = new FileExtensionPair("cpp", "h", NamingConventionStyle.NONE);
            }
        }
        return Pair.createNonNull((Object)fileName, (Object)extensionPair);
    }

    @Override
    protected boolean isValidName(@NotNull String selectedName) {
        return StandardFileSystems.local().isValidName(selectedName);
    }

    @Override
    @NotNull
    protected T createDialog(@NotNull @NlsContexts.Label String defaultName) {
        return (T)((Object)new CreateFileDialog(defaultName, this.getHelpId()));
    }

    public class CreateFileDialog
    extends OCNewFileActionBase.CreateFileDialogBase {
        @Nullable
        protected FileExtensionPair myFileExtensionPair;
        protected TemplateKindCombo myKindCombo;
        @NotNull
        protected ImmutableList<FileExtensionPair> pairs;

        public CreateFileDialog(@NonNls String defaultName, String helpId) {
            this(CidrLangBundle.message("action.create.new.file", this$0.getTemplatePresentation().getText()), defaultName, helpId);
        }

        public CreateFileDialog(@NlsContexts.Label String title, @Nullable String defaultName, String helpId) {
            super(title, defaultName, PluginUtils.hasCLion() ? helpId : null);
            this.pairs = ContainerUtil.immutableList((Object[])new FileExtensionPair[0]);
        }

        @Override
        protected void addNameField(FormBuilder formBuilder) {
            this.addNameField(formBuilder, true);
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            this.createFileTypesCombo(formBuilder);
        }

        protected void createFileTypesCombo(FormBuilder formBuilder) {
            JPanel panel = new JPanel(new BorderLayout(5, 0));
            this.myKindCombo = new TemplateKindCombo();
            panel.add((Component)this.myKindCombo, "Center");
            panel.add((Component)this.createPreferencesButton(), "East");
            formBuilder.addLabeledComponent(CidrLangBundle.message("create.field.type", new Object[0]), (JComponent)panel);
            this.reloadExtensions();
            ((JComboBox)this.myKindCombo.getChildComponent()).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    int selectedIndex;
                    if (event.getStateChange() == 1 && (selectedIndex = CreateFileDialog.this.myKindCombo.getComboBox().getSelectedIndex()) < CreateFileDialog.this.pairs.size()) {
                        CreateFileDialog.this.myFileExtensionPair = (FileExtensionPair)CreateFileDialog.this.pairs.get(selectedIndex);
                    }
                    CreateFileDialog.this.validateOkAction();
                }
            });
            this.myKindCombo.registerUpDownHint((JComponent)this.myNameField);
        }

        protected void reloadExtensions() {
            String prevPairName = this.myFileExtensionPair == null ? null : this.getPresentableName(this.myFileExtensionPair);
            FileExtensionPair currentPair = null;
            this.myKindCombo.clear();
            HashSet<String> processedNames = new HashSet<String>();
            ArrayList<FileExtensionPair> filteredPairs = new ArrayList<FileExtensionPair>();
            for (FileExtensionPair pair : OCNewFileWithSelectedExtensionAction.this.getExtensions(OCNewFileWithSelectedExtensionAction.this.getState().project)) {
                String presentableName2 = this.getPresentableName(pair);
                if (!processedNames.add(presentableName2)) continue;
                this.myKindCombo.addItem(presentableName2, null, presentableName2);
                filteredPairs.add(pair);
                if (!presentableName2.equals(prevPairName)) continue;
                currentPair = pair;
            }
            if (!filteredPairs.isEmpty()) {
                this.pairs = ContainerUtil.immutableList(filteredPairs);
                this.myFileExtensionPair = currentPair == null ? (FileExtensionPair)this.pairs.get(0) : currentPair;
                this.myKindCombo.setSelectedName(this.getPresentableName(this.myFileExtensionPair));
            }
        }

        @Override
        @Nullable
        protected String collectOkActionErrors() {
            if (this.myKindCombo.getComboBox().getItemCount() == 0) {
                return CidrLangBundle.message("fileExtensions.noCompatibleTypes", new Object[0]);
            }
            return super.collectOkActionErrors();
        }

        @NotNull
        @NlsSafe
        protected String getPresentableName(@NotNull FileExtensionPair pair) {
            return "." + pair.mySourceExt + " / ." + pair.myHeaderExt;
        }

        @NotNull
        private InplaceButton createPreferencesButton() {
            return new InplaceButton(CidrLangBundle.message("fileExtensions.editFileTypesTooltip", new Object[0]), AllIcons.General.Settings, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CodeStyleSettings settings = CodeStyle.getSettings((Project)OCNewFileWithSelectedExtensionAction.this.getState().project);
                    OCFileExtensionsSettingsProvider.MyMasterDetailsComponent configurable = OCFileExtensionsSettingsProvider.createConfigurable(settings);
                    boolean ok = ShowSettingsUtil.getInstance().editConfigurable(OCNewFileWithSelectedExtensionAction.this.getState().project, (Configurable)configurable);
                    if (ok) {
                        CreateFileDialog.this.saveCodeStyleSettings();
                        CreateFileDialog.this.reloadExtensions();
                    }
                }
            });
        }

        private void saveCodeStyleSettings() {
            CodeStyleSettingsManager.getInstance((Project)OCNewFileWithSelectedExtensionAction.this.getState().project).updateSettingsTracker();
            CodeStyleSchemesImpl.getSchemeManager().save(new ArrayList());
        }
    }
}

