/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandler;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewFileLangBackendHandlerProvider {
    private static final Logger LOG = Logger.getInstance(OCNewFileLangBackendHandlerProvider.class);

    @NotNull
    public static OCNewFileLangBackendHandler getHandler() {
        List handlers = OCNewFileLangBackendHandler.EP_NAME.getExtensionList();
        if (handlers.isEmpty()) {
            LOG.debug("OCNewFileLangBackendHandler is not registered: Using default one");
            return OCNewFileLangBackendHandlerProvider.getDefaultHandler();
        }
        LOG.assertTrue(handlers.size() == 1);
        return (OCNewFileLangBackendHandler)handlers.get(0);
    }

    @NotNull
    private static OCNewFileLangBackendHandler getDefaultHandler() {
        return new OCNewFileLangBackendHandler(){

            @Override
            public boolean isProjectLoaded(@NotNull Project project) {
                return true;
            }

            @Override
            @Nullable
            public VirtualFile getVirtualFile(@NotNull PsiFile file) {
                return file.getVirtualFile();
            }

            @Override
            public void handleCreatedFile(@NotNull PsiFile file) {
            }

            @Override
            @NotNull
            public LanguageFileType getFileType() {
                return PlainTextFileType.INSTANCE;
            }

            @Override
            @NotNull
            public Language getLanguage() {
                return PlainTextLanguage.INSTANCE;
            }

            @Override
            public boolean isCppFileExtension(@NotNull String extension, @NotNull Project project) {
                return OCFileTypeHelpers.isCppFile(extension);
            }

            @Override
            @NotNull
            public String getHeaderGuardStylePattern(@NotNull String filePath, @NotNull Project project) {
                String fileName = new File(filePath).getName();
                return StringUtil.toUpperCase((String)StringUtil.join((Collection)StringUtil.getWordsIn((String)fileName), (String)"_"));
            }

            @Override
            @NotNull
            public Couple<String> determineExtensions(@NotNull PsiFile sampleFile, @Nullable String preferredSourceExt, @Nullable String preferredHeaderExt) {
                return Couple.of((Object)preferredSourceExt, (Object)preferredHeaderExt);
            }
        };
    }
}

