/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CidrLangUtil;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandlerProvider;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewFileHelperUtil {
    private static final String PROJECT_TEMPLATE_PROPERTY1 = "PROJECT_NAME";
    private static final String PROJECT_TEMPLATE_PROPERTY2 = "PROJECTNAME";

    public static void addCreatedFiles(@NotNull PsiDirectory directory, String @NotNull [] fileNames, PsiFile @NotNull [] resultElements, @NotNull Project project, @NotNull Function<? super VirtualFile, Void> fileHandler) {
        for (int i = 0; i < resultElements.length; ++i) {
            PsiFile file = resultElements[i];
            file = file == null ? directory.createFile(fileNames[i]) : (PsiFile)directory.add((PsiElement)file);
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{virtualFile});
                fileHandler.fun((Object)virtualFile);
            }
            resultElements[i] = file;
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
            OCNewFileLangBackendHandlerProvider.getHandler().handleCreatedFile(file);
        }
    }

    public static void fillCommonTemplateProperties(@NotNull Properties properties, @Nullable String projectName) {
        properties.setProperty(PROJECT_TEMPLATE_PROPERTY1, projectName);
        properties.setProperty(PROJECT_TEMPLATE_PROPERTY2, projectName);
    }

    public static <T extends OCNewFileActionBase.CreateFileDialogBase> void initPropertyField(final T dialog, final JTextField textEdit, final Ref<String> property) {
        textEdit.setMinimumSize(new Dimension(250, textEdit.getPreferredSize().height));
        textEdit.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                property.set((Object)textEdit.getText());
                dialog.validateOkAction();
            }
        });
    }

    public static <T extends OCNewFileActionBase.CreateFileDialogBase> void addTextEdit(T dialog, FormBuilder formBuilder, @NotNull @NonNls Ref<String> property, @NotNull @NonNls String defaultValue, @NotNull @NlsContexts.Label String label) {
        JTextField textEdit = new JTextField();
        textEdit.setText(defaultValue);
        OCNewFileHelperUtil.initPropertyField(dialog, textEdit, property);
        formBuilder.addLabeledComponent(label, (JComponent)textEdit);
    }

    public static boolean isValidNamespaceName(@NotNull String namespaceName) {
        if (!(namespaceName = namespaceName.trim()).isEmpty() && !CidrLangUtil.isIdentifier(namespaceName, CLanguageKind.CPP, null)) {
            @NotNull List subNamespaces = StringUtil.split((String)namespaceName, (String)"::", (boolean)true, (boolean)false);
            return ContainerUtil.all((Collection)subNamespaces, name -> !name.trim().isEmpty() && CidrLangUtil.isIdentifier(name.trim(), CLanguageKind.CPP, null));
        }
        return true;
    }
}

