/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelperUtil;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandlerProvider;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.ui.OCListWithEmptyItemHintRenderer;
import icons.CidrLangIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CPPQtUiClassAction
extends OCNewFileWithSelectedExtensionAction<MyCreateClassDialog> {
    @NonNls
    protected static final String QT_CLASS_TEMPLATE_NAME = "Qt Class.cpp";
    @NonNls
    protected static final String QT_CLASS_HEADER_TEMPLATE_NAME = "Qt Class Header.h";
    @NonNls
    protected static final String QT_FORM_UI_TEMPLATE_NAME = "Qt Designer Form.ui";
    @NonNls
    protected static final String QT_PARENT_CLASS_PROPERTY = "PARENT_CLASS";
    @NonNls
    protected static final String QT_USER_BEGIN_NAMESPACE_PROPERTY = "USER_BEGIN_NAMESPACE";
    @NonNls
    protected static final String QT_USER_END_NAMESPACE_PROPERTY = "USER_END_NAMESPACE";
    @NonNls
    protected static final String QT_NAMESPACE_SPECIFIER_PROPERTY = "NAMESPACE_SPECIFIER";
    @NonNls
    protected static final String QT_UI_HEADER_FILENAME_TEMPLATE_PROPERTY = "UI_HEADER_FILENAME";
    @NonNls
    protected static final String QT_CLASS_DEPENDENT_CONTENT = "CLASS_DEPENDENT_CONTENT";
    @NonNls
    private static final String NEW_QT_CLASS_HELP_TOPIC_ID = "dialogs.newqtuiclass";
    @NonNls
    protected String myFilename = "";
    @NonNls
    protected Ref<String> myParentClass = new Ref((Object)"");
    @NonNls
    protected Ref<String> myEnclosingNamespace = new Ref((Object)"");

    public CPPQtUiClassAction() {
        super((FileType)OCNewFileLangBackendHandlerProvider.getHandler().getFileType(), CidrLangBundle.message("create.cpp.qt.ui.class.title", new Object[0]), CidrLangBundle.message("create.cpp.qt.ui.class.description", new Object[0]), CidrLangIcons.FileTypes.UiForm);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        LOG.assertTrue(this.getState() != null, (Object)"state");
        LOG.assertTrue(this.myFilename != null, (Object)"name");
        return CPPQtUiClassAction.getNewNames(this.myFilename, this.getExtensions(this.getState().project).get(0));
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        LOG.assertTrue(this.myFilename != null, (Object)"name");
        return CPPQtUiClassAction.getNewNames(this.myFilename, this.getExtensions(this.getState().project).get(0));
    }

    @NotNull
    private static OCNewFileActionBase.NewFileNames getNewNames(@NotNull String selectedName, FileExtensionPair pair) {
        return new OCNewFileActionBase.NewFileNames(selectedName + "." + pair.mySourceExt, selectedName + "." + pair.myHeaderExt, Collections.singletonList(selectedName + ".ui"));
    }

    @Override
    protected boolean isValidName(@NotNull String selectedName) {
        return StringUtil.isJavaIdentifier((String)selectedName);
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, Project project) {
        String headerName;
        properties.setProperty(QT_PARENT_CLASS_PROPERTY, (String)this.myParentClass.get());
        if (!((String)this.myEnclosingNamespace.get()).isEmpty()) {
            String enclosingNamespace = (String)this.myEnclosingNamespace.get();
            properties.setProperty(QT_NAMESPACE_SPECIFIER_PROPERTY, enclosingNamespace + "::");
            properties.setProperty(QT_USER_BEGIN_NAMESPACE_PROPERTY, "namespace " + enclosingNamespace + " {");
            properties.setProperty(QT_USER_END_NAMESPACE_PROPERTY, "} // " + enclosingNamespace);
        } else {
            properties.setProperty(QT_NAMESPACE_SPECIFIER_PROPERTY, "");
            properties.setProperty(QT_USER_BEGIN_NAMESPACE_PROPERTY, "");
            properties.setProperty(QT_USER_END_NAMESPACE_PROPERTY, "");
        }
        if (this.getState() != null) {
            headerName = this.getNewFileNames(this.mySelectedName).getHeaderName();
        } else {
            assert (sampleFile != null);
            headerName = this.getNewFileNames(this.mySelectedName, sampleFile).getHeaderName();
        }
        properties.setProperty("HEADER_FILENAME", headerName);
        String uiHeaderName = this.mySelectedName.equalsIgnoreCase(this.myFilename) ? "ui_" + this.mySelectedName + ".h" : "ui_" + this.myFilename + ".h";
        properties.setProperty(QT_UI_HEADER_FILENAME_TEMPLATE_PROPERTY, uiHeaderName);
        properties.setProperty(QT_CLASS_DEPENDENT_CONTENT, ((String)this.myParentClass.get()).equals("QMainWindow") ? "\n    <widget class=\"QWidget\" name=\"centralwidget\"/>\n    <widget class=\"QMenuBar\" name=\"menubar\">\n      <property name=\"geometry\">\n        <rect>\n          <x>0</x>\n          <y>0</y>\n          <width>400</width>\n          <height>17</height>\n        </rect>\n      </property>\n    </widget>\n    <widget class=\"QStatusBar\" name=\"statusbar\"/>" : "");
    }

    @Override
    protected String getFileTemplate(String fileName) {
        if (OCFileTypeHelpers.isSourceFile(fileName)) {
            return QT_CLASS_TEMPLATE_NAME;
        }
        if (OCFileTypeHelpers.isHeaderFile(fileName)) {
            return QT_CLASS_HEADER_TEMPLATE_NAME;
        }
        if (fileName.endsWith(".ui")) {
            return QT_FORM_UI_TEMPLATE_NAME;
        }
        assert (false);
        return null;
    }

    @Override
    @NotNull
    protected MyCreateClassDialog createDialog(@NotNull @NlsContexts.Label String defaultName) {
        return new MyCreateClassDialog(defaultName, this.getHelpId());
    }

    @Override
    @NotNull
    protected List<FileExtensionPair> getExtensions(@NotNull Project project) {
        FileExtensionPair extensionPair = (FileExtensionPair)ContainerUtil.find(super.getExtensions(project), pair -> OCNewFileLangBackendHandlerProvider.getHandler().isCppFileExtension("." + pair.mySourceExt, project));
        if (extensionPair == null) {
            extensionPair = new FileExtensionPair("cpp", "h", NamingConventionStyle.NONE);
        }
        return ContainerUtil.immutableList(Collections.singletonList(extensionPair));
    }

    @Override
    protected void selectResult(@NotNull IdeView view, PsiFile @NotNull [] createdElements) {
        ContainerUtil.sort((Object[])createdElements, Comparator.comparing(psiFile -> psiFile.getName().endsWith(".h")));
        super.selectResult(view, createdElements);
    }

    @Override
    @NotNull
    @NonNls
    protected String getHelpId() {
        return NEW_QT_CLASS_HELP_TOPIC_ID;
    }

    public class MyCreateClassDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        @NlsSafe
        private static final String DUMMY = "Dummy";
        private JTextField myFilenameBaseField;
        @NotNull
        private final @NlsContexts.Label String myFilenameBaseFieldTitle;
        @NlsSafe
        private static final String myMainWindowClass = "QMainWindow";
        @NlsSafe
        private final String[] myAllowedParentClasses;
        @NlsSafe
        private static final String myMainWindowSpecialContent = "\n    <widget class=\"QWidget\" name=\"centralwidget\"/>\n    <widget class=\"QMenuBar\" name=\"menubar\">\n      <property name=\"geometry\">\n        <rect>\n          <x>0</x>\n          <y>0</y>\n          <width>400</width>\n          <height>17</height>\n        </rect>\n      </property>\n    </widget>\n    <widget class=\"QStatusBar\" name=\"statusbar\"/>";
        private boolean mySyncFilename;
        private boolean myChangedFromCode;

        public MyCreateClassDialog(@Nullable String defaultName, String helpId) {
            super(CPPQtUiClassAction.this, CidrLangBundle.message("create.cpp.qt.ui.class.title", new Object[0]), defaultName, helpId);
            this.myAllowedParentClasses = new String[]{"QWidget", myMainWindowClass, "QDialog"};
            this.mySyncFilename = true;
            this.myChangedFromCode = false;
            this.myFilenameBaseFieldTitle = CidrLangBundle.message("create.cpp.qt.filename.base.title", new Object[0]);
            CPPQtUiClassAction.this.myEnclosingNamespace.set((Object)"");
        }

        @Override
        @Nullable
        protected String collectOkActionErrors() {
            if (StringUtil.isEmptyOrSpaces((String)this.myFilenameBaseField.getText())) {
                return "";
            }
            String parent = (String)CPPQtUiClassAction.this.myParentClass.get();
            if (!StringUtil.isJavaIdentifier((String)parent)) {
                return CidrLangBundle.message("create.cpp.qt.ui.invalid.parent.message", new Object[0]);
            }
            if (!OCNewFileHelperUtil.isValidNamespaceName((String)CPPQtUiClassAction.this.myEnclosingNamespace.get())) {
                return CidrLangBundle.message("create.cpp.invalid.namespace.name.message", new Object[0]);
            }
            return super.collectOkActionErrors();
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            this.addFilenameField(formBuilder);
            this.addParentCombobox(formBuilder);
            OCNewFileHelperUtil.addTextEdit(this, formBuilder, CPPQtUiClassAction.this.myEnclosingNamespace, "", CidrLangBundle.message("create.cpp.enclosing.namespace.title", new Object[0]));
        }

        @Override
        protected void addNameField(FormBuilder formBuilder) {
            this.addNameField(formBuilder, false);
        }

        private void addFilenameField(FormBuilder formBuilder) {
            this.myFilenameBaseField = new JTextField();
            this.myFilenameBaseField.setText(this.myNameField.getText());
            this.myFilenameBaseField.setMinimumSize(new Dimension(250, this.myNameField.getPreferredSize().height));
            this.myFilenameBaseField.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChange() {
                    MyCreateClassDialog.this.validateOkAction();
                    if (!MyCreateClassDialog.this.myChangedFromCode && MyCreateClassDialog.this.mySyncFilename) {
                        MyCreateClassDialog.this.mySyncFilename = false;
                    }
                    CPPQtUiClassAction.this.myFilename = MyCreateClassDialog.this.myFilenameBaseField.getText();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChange();
                }
            });
            JTextField nameFieldComponent = this.myFilenameBaseField;
            formBuilder.addLabeledComponent(this.myFilenameBaseFieldTitle, (JComponent)nameFieldComponent);
            this.myFilenameBaseField.setEnabled(this.isNameFieldEnabled());
            this.myNameField.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChange() {
                    if (MyCreateClassDialog.this.mySyncFilename) {
                        try {
                            MyCreateClassDialog.this.myChangedFromCode = true;
                            MyCreateClassDialog.this.myFilenameBaseField.setText(MyCreateClassDialog.this.myNameField.getText().toLowerCase(Locale.ENGLISH));
                        }
                        finally {
                            MyCreateClassDialog.this.myChangedFromCode = false;
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChange();
                }
            });
        }

        private void addParentCombobox(FormBuilder formBuilder) {
            ComboBox combo = new ComboBox();
            FixedComboBoxEditor comboEditor = new FixedComboBoxEditor();
            combo.setEditor((ComboBoxEditor)comboEditor);
            combo.setEditable(true);
            combo.setRenderer((ListCellRenderer)new OCListWithEmptyItemHintRenderer(CidrLangBundle.message("create.cpp.qt.custom.class.title", new Object[0])));
            for (String parentClass : this.myAllowedParentClasses) {
                combo.addItem((Object)parentClass);
            }
            combo.addItem((Object)"");
            JTextField textEdit = (JTextField)comboEditor.getEditorComponent();
            OCNewFileHelperUtil.initPropertyField(this, textEdit, CPPQtUiClassAction.this.myParentClass);
            combo.setSelectedIndex(0);
            CPPQtUiClassAction.this.myParentClass.set((Object)((String)combo.getItem()));
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)combo);
            formBuilder.addLabeledComponent(CidrLangBundle.message("create.cpp.qt.parent.class.title", new Object[0]), (JComponent)panel);
        }

        @Override
        protected void createFileTypesCombo(FormBuilder formBuilder) {
            this.myKindCombo = new TemplateKindCombo();
            this.myKindCombo.addItem(DUMMY, null, DUMMY);
        }

        @Override
        @NotNull
        protected String getPresentableName(@NotNull FileExtensionPair pair) {
            String name = super.getPresentableName(pair);
            NamingConventionStyle nc = pair.myFileNamingConvention;
            return nc == NamingConventionStyle.NONE ? name : name + "  [" + nc + "]";
        }
    }
}

