/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.light.OCLightFileType;
import com.jetbrains.cidr.lang.light.OCSlowLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLanguageUtilsBase {
    protected static boolean isLightPsiOn() {
        return false;
    }

    protected static boolean assertLightPsiOn(@Nullable Object message) {
        return CidrLogService.LOG.assertTrue(OCLanguageUtilsBase.isLightPsiOn(), message);
    }

    @NotNull
    public static Language getConfigLanguage() {
        return OCLanguage.getInstance();
    }

    @NotNull
    public static Language getLightLanguage() {
        return OCLanguage.getInstance();
    }

    @NotNull
    public static Language getSlowLanguage() {
        return OCLanguageUtilsBase.isLightPsiOn() ? OCSlowLanguage.getInstance() : OCLanguage.getInstance();
    }

    @NotNull
    public static FileType getBaseFileType() {
        return OCLanguageUtilsBase.isLightPsiOn() ? OCLightFileType.INSTANCE : OCFileType.INSTANCE;
    }

    public static boolean isSupported(@Nullable Language language) {
        return language == OCLanguageUtilsBase.getSlowLanguage() || language == OCLanguageUtilsBase.getLightLanguage();
    }

    public static boolean isSupported(@NotNull VirtualFile virtualFile) {
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        return fileTypeManager.isFileOfType(virtualFile, (FileType)OCFileType.INSTANCE) || fileTypeManager.isFileOfType(virtualFile, (FileType)OCLightFileType.INSTANCE) && OCLanguageUtilsBase.assertLightPsiOn(virtualFile);
    }

    public static boolean isSupported(@NotNull FileType fileType) {
        return fileType == OCFileType.INSTANCE || fileType == OCLightFileType.INSTANCE && OCLanguageUtilsBase.assertLightPsiOn(fileType);
    }
}

