/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.intellij.util.SofterReference;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestScopeElementForCacheImpl
extends CidrTestScopeElementImpl {
    protected final VirtualFile myVFile;
    protected final Project myProject;
    protected long myOffsetAsNaturalOrder;
    @Nullable
    protected SofterReference<PsiElement> myPsiElement;

    public CidrTestScopeElementForCacheImpl(@NotNull PsiFile psiFile, long offsetAsNaturalOrder, @Nullable String suiteName, @Nullable String testName, @Nullable Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> factory) {
        super(suiteName, testName, factory);
        this.myVFile = psiFile.getVirtualFile();
        this.myProject = psiFile.getProject();
        this.myOffsetAsNaturalOrder = offsetAsNaturalOrder;
    }

    @Override
    public long getSortIndex() {
        return this.myOffsetAsNaturalOrder;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiElement element;
        if (this.myPsiElement != null) {
            PsiElement element2 = (PsiElement)this.myPsiElement.get();
            if (element2 != null && element2.isValid()) {
                return element2;
            }
            this.myPsiElement = null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myVFile);
        this.verify(psiFile, this.myVFile);
        assert (psiFile != null);
        if (OCTestExecution.canWaitInThisThread() && (element = this.getElementSlow(psiFile)) != null) {
            CidrTestLog.LOG.debug("Moved element was found");
            this.myPsiElement = new SofterReference((Object)element);
            return element;
        }
        element = this.findFromOrderInFile(psiFile);
        if (element != null) {
            CidrTestLog.LOG.debug("Element from position");
            return element;
        }
        CidrTestLog.LOG.debug("File as element");
        return psiFile;
    }

    @Contract(pure=true)
    @Nullable
    protected PsiElement getElementSlow(@NotNull PsiFile psiFile) {
        return null;
    }

    @Contract(pure=true)
    protected PsiElement findFromOrderInFile(@NotNull PsiFile psiFile) {
        return psiFile.findElementAt((int)this.myOffsetAsNaturalOrder);
    }

    protected void verify(@Nullable PsiFile psiFile, @NotNull VirtualFile vFile) {
        if (psiFile == null) {
            CidrTestLog.LOG.error("File not found:", new String[]{vFile.getPath()});
        }
    }
}

