/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.console.ConsoleViewWrapperBase;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrConsoleBuilder;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.CidrRestartActionProvider;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.execution.testing.CidrBeforeTestRunTaskProvider;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrTestListParserAndHolder;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunMode;
import com.jetbrains.cidr.execution.testing.CidrTestRunProfileStateWithPreparation;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestCommandLineState<CONFIGURATION extends CidrTestRunConfiguration>
extends CidrCommandLineState
implements CidrRestartActionProvider,
CidrTestRunProfileStateWithPreparation {
    @NotNull
    private final Executor myExecutor;
    @NotNull
    protected final CONFIGURATION myConfiguration;
    @Nullable
    protected final CidrTestScope myFailedTests;
    @NotNull
    private final Supplier<CidrTestScope> myEmptyTestScopeProducer;
    @NotNull
    protected volatile CidrTestRunMode myRunMode = CidrTestRunMode.RUN_TEST;

    public CidrTestCommandLineState(@NotNull CONFIGURATION configuration, @NotNull CidrLauncher launcher, @NotNull ExecutionEnvironment env, @NotNull Executor executor, @Nullable CidrTestScope failedTests, @NotNull Supplier<CidrTestScope> emptyTestScopeProducer) {
        super(env, launcher);
        this.myConfiguration = configuration;
        this.myExecutor = executor;
        this.myFailedTests = failedTests;
        this.myEmptyTestScopeProducer = emptyTestScopeProducer;
    }

    @NotNull
    public Executor getExecutor() {
        return this.myExecutor;
    }

    @NotNull
    public CONFIGURATION getConfiguration() {
        return this.myConfiguration;
    }

    @NotNull
    public CidrRerunFailedTestsAction createRestartAction(@NotNull ExecutionConsole console) {
        SMTRunnerConsoleView consoleView = CidrTestCommandLineState.getConsole(console);
        CidrRerunFailedTestsAction rerunFailedTestsAction = this.doCreateRerunFailedTestsAction(consoleView);
        rerunFailedTestsAction.init(consoleView.getProperties());
        rerunFailedTestsAction.setModelProvider(() -> ((SMTRunnerConsoleView)consoleView).getResultsViewer());
        return rerunFailedTestsAction;
    }

    @NotNull
    public CidrTestScope testScope() {
        if (this.myFailedTests != null) {
            return this.myFailedTests;
        }
        CidrTestRunConfigurationData<?> delegate = this.myConfiguration.getTestData();
        String pattern = StringUtil.notNullize((String)delegate.getTestPattern());
        CidrTestScope testScope = this.createEmptyTestScope();
        return delegate.getTestMode() == CidrTestRunConfigurationData.Mode.PATTERN && !pattern.isEmpty() ? testScope.configureForPreRenderedScope(pattern) : testScope.addScopeElement(this.createTestScopeElement(delegate.getTestSuite(), delegate.getTestName()));
    }

    @Contract(pure=true)
    public GeneralCommandLine prepareCommandLine(@NotNull GeneralCommandLine cl) {
        return cl;
    }

    @NotNull
    public ConsoleView createConsole(@NotNull CidrConsoleBuilder builder) {
        return builder.createConsole(this.myConfiguration.getType(), this.myConfiguration.getTestData().createTestConsoleProperties(this.getExecutor(), this.getExecutionTarget()));
    }

    protected CidrTestScope createEmptyTestScope() {
        return this.myEmptyTestScopeProducer.get();
    }

    @NotNull
    protected abstract CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(@NotNull SMTRunnerConsoleView var1);

    @Override
    public void prepareTestExecutionEnvironment(@NotNull ProgressIndicator progress) {
        CidrTestRunConfigurationData<?> data = this.getConfiguration().getTestData();
        if (data instanceof CidrTestListParserAndHolder) {
            this.getTestListFromRunAndParseTestInfo(progress, (CidrTestListParserAndHolder)((Object)data));
        }
        if (this.needCloseBeforeTestRunTaskResults()) {
            this.closeBeforeTestRunTaskResults(progress);
        }
    }

    @Contract(pure=true)
    protected boolean needCloseBeforeTestRunTaskResults() {
        return true;
    }

    protected void closeBeforeTestRunTaskResults(@NotNull ProgressIndicator progress) {
        Content beforeTestRunContent;
        Content content = beforeTestRunContent = progress instanceof UserDataHolder ? (Content)CidrBeforeTestRunTaskProvider.CONTENT.get((UserDataHolder)progress) : null;
        if (beforeTestRunContent != null) {
            CidrBeforeTestRunTaskProvider.PROGRESS.set((UserDataHolder)beforeTestRunContent, null);
            UIUtil.invokeAndWaitIfNeeded(() -> Objects.requireNonNull(beforeTestRunContent.getManager()).removeContent(beforeTestRunContent, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getTestListFromRunAndParseTestInfo(@NotNull ProgressIndicator progress, @NotNull CidrTestListParserAndHolder data) {
        data.clean();
        Executor safeDryExecutorForTestExtractor = DefaultRunExecutor.getRunExecutorInstance();
        ProgramRunner safeDryRunnerForTestExtractor = ProgramRunner.getRunner((String)safeDryExecutorForTestExtractor.getId(), this.myConfiguration);
        if (Registry.is((String)"cidr.test.prepare.test.list") && safeDryRunnerForTestExtractor != null) {
            try {
                ProcessOutput output;
                this.myRunMode = CidrTestRunMode.GET_TEST_LIST;
                ProcessHandler ph = (ProcessHandler)UIUtil.invokeAndWaitIfNeeded(() -> {
                    try {
                        ExecutionEnvironment environment = new ExecutionEnvironmentBuilder(this.getEnvironment()).executor(safeDryExecutorForTestExtractor).runner(safeDryRunnerForTestExtractor).runnerSettings(null).build();
                        return this.getConfigurationForTestListExtraction().createLauncher(environment).startProcess(this);
                    }
                    catch (ExecutionException e) {
                        progress.setText2(CidrExecutionBundle.message("warning.cannot.collect.info.about.tests.to.run", e.getLocalizedMessage()));
                        return null;
                    }
                });
                if (ph != null && !(output = CidrRunProcessUtil.runProcess((ProcessHandler)ph, (ProgressIndicator)progress, (int)Registry.intValue((String)"cidr.test.prepare.test.list.timeout"))).isTimeout() && !output.isCancelled()) {
                    data.parse(output);
                }
            }
            finally {
                this.myRunMode = CidrTestRunMode.RUN_TEST;
            }
        }
    }

    private CidrTestRunConfiguration getConfigurationForTestListExtraction() {
        if (Registry.is((String)"cidr.test.prepare.test.list.without.elevation") && this.myConfiguration instanceof CidrRunConfiguration && ((CidrRunConfiguration)this.myConfiguration).isElevated()) {
            CidrRunConfiguration configurationWithUserPrivileges = (CidrRunConfiguration)this.myConfiguration.clone();
            configurationWithUserPrivileges.setElevated(false);
            return (CidrTestRunConfiguration)((Object)configurationWithUserPrivileges);
        }
        return this.myConfiguration;
    }

    @NotNull
    protected abstract CidrTestScopeElement createTestScopeElement(@Nullable String var1, @Nullable String var2);

    @NotNull
    private static SMTRunnerConsoleView getConsole(@NotNull ExecutionConsole console) {
        return console instanceof ConsoleViewWrapperBase ? (SMTRunnerConsoleView)((ConsoleViewWrapperBase)console).getDelegate() : (SMTRunnerConsoleView)console;
    }

    protected static void addParametersAtFirstPos(@NotNull GeneralCommandLine cl, String ... params) {
        ParametersList plist = cl.getParametersList();
        for (String param : params) {
            plist.addAt(0, param);
        }
    }
}

