/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrRerunFailedTestsActionEx
extends CidrRerunFailedTestsAction {
    private final Function<? super Pair<AbstractTestProxy, Project>, String> myProxyToTestSwitch;

    public CidrRerunFailedTestsActionEx(@NotNull ComponentContainer componentContainer, @NotNull Function<? super Pair<AbstractTestProxy, Project>, String> proxyToTestSwitch, @NotNull CidrTestCommandLineState<?> commandLineState) {
        super(componentContainer, commandLineState);
        this.myProxyToTestSwitch = proxyToTestSwitch;
    }

    @NotNull
    protected Filter getFilter(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        return super.getFilter(project, searchScope).and(new Filter(){

            public boolean shouldAccept(AbstractTestProxy t) {
                return t.isLeaf();
            }
        });
    }

    @Override
    @Nullable
    protected CidrTestScopeElement getElement(@NotNull AbstractTestProxy test, @NotNull Project project) {
        final String testSwitch = (String)this.myProxyToTestSwitch.fun((Object)Pair.create((Object)test, (Object)project));
        return testSwitch == null ? null : new CidrTestScopeElementImpl(){

            @Override
            @Contract(pure=true)
            @NotNull
            public String getPattern() {
                return testSwitch;
            }
        };
    }
}

