/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.jetbrains.cidr.execution.CidrRunProfile;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrRerunFailedTestsAction
extends AbstractRerunFailedTestsAction {
    private final CidrTestCommandLineState<?> myCommandLineState;

    public CidrRerunFailedTestsAction(@NotNull ComponentContainer componentContainer, CidrTestCommandLineState<?> commandLineState) {
        super(componentContainer);
        this.myCommandLineState = commandLineState;
    }

    @Nullable
    public AbstractRerunFailedTestsAction.MyRunProfile getRunProfile(@Nullable ExecutionEnvironment environment) {
        TestFrameworkRunningModel model = this.getModel();
        if (model == null) {
            return null;
        }
        RunConfiguration configuration = (RunConfiguration)model.getProperties().getConfiguration();
        List failedTests = this.getFailedTests(configuration.getProject());
        CidrTestScope failedScope = this.myCommandLineState.createEmptyTestScope();
        for (AbstractTestProxy test : failedTests) {
            CidrTestScopeElement element = this.getElement(test, configuration.getProject());
            if (element == null) continue;
            failedScope.addScopeElement(element);
        }
        return ((CidrTestRunConfiguration)configuration).createTestRunProfile(failedScope);
    }

    @Nullable
    protected abstract CidrTestScopeElement getElement(@NotNull AbstractTestProxy var1, Project var2);

    public static class CidrReturnTestProfile
    extends AbstractRerunFailedTestsAction.MyRunProfile
    implements CidrRunProfile {
        private final CidrTestScope myFailedTests;

        public CidrReturnTestProfile(@NotNull CidrTestRunConfiguration configuration, @NotNull CidrTestScope failedTests) {
            super((RunConfigurationBase)configuration);
            this.myFailedTests = failedTests;
        }

        @Override
        @Nullable
        public CommandLineState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
            return ((CidrTestRunConfiguration)this.getPeer()).createState(env, executor, this.myFailedTests);
        }
    }
}

