/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrMetaParam {
    @NotNull
    @NonNls
    public static final String PAIRS_SPLITTER = ";";
    @NotNull
    @NonNls
    public static final String KEY_VALUE_SPLITTER = ":";
    @NotNull
    @NonNls
    public static final String LINE = "line";
    @NotNull
    @NonNls
    public static final String TARGET = "target";
    @NotNull
    @NonNls
    public static final String IS_TEST = "isTest";

    public static Map<String, String> parse(@Nullable @NonNls String metaInfo) {
        if (metaInfo == null) {
            return Collections.emptyMap();
        }
        List pairs = StringUtil.split((String)metaInfo, (String)PAIRS_SPLITTER);
        HashMap<String, String> res = new HashMap<String, String>();
        for (String pair : pairs) {
            List keyValue = StringUtil.split((String)pair, (String)KEY_VALUE_SPLITTER);
            if (keyValue.size() != 2) continue;
            res.put(((String)keyValue.get(0)).trim(), ((String)keyValue.get(1)).trim());
        }
        return res;
    }

    @Nullable
    @NonNls
    public static String serialize(@Nullable Map<String, String> metaMap) {
        if (metaMap == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String key : metaMap.keySet()) {
            if (sb.length() != 0) {
                sb.append(PAIRS_SPLITTER);
            }
            sb.append(key).append(KEY_VALUE_SPLITTER).append(metaMap.get(key));
        }
        return sb.toString();
    }

    @SafeVarargs
    @NotNull
    public static String serialize(Pair<String, Object> ... keyValues) {
        StringBuilder sb = new StringBuilder();
        for (Pair<String, Object> keyValue : keyValues) {
            if (sb.length() != 0) {
                sb.append(PAIRS_SPLITTER);
            }
            sb.append((String)keyValue.first).append(KEY_VALUE_SPLITTER);
            if (keyValue.second == null) continue;
            sb.append(keyValue.second);
        }
        return sb.toString();
    }
}

