/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build.runners;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.util.concurrency.FutureResult;
import com.jetbrains.cidr.execution.build.runners.BackgroundableProjectTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrBuildSessionsQueueManager;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import com.jetbrains.cidr.execution.build.runners.WaitingTask;
import java.util.UUID;
import java.util.concurrent.Future;
import kotlin.Metadata;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH&R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/execution/build/runners/CidrProjectTaskRunner;", "Lcom/intellij/task/ProjectTaskRunner;", "()V", "buildSystemId", "", "getBuildSystemId", "()Ljava/lang/String;", "run", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/task/ProjectTaskRunner$Result;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/task/ProjectTaskContext;", "tasks", "", "Lcom/intellij/task/ProjectTask;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/task/ProjectTaskContext;[Lcom/intellij/task/ProjectTask;)Lorg/jetbrains/concurrency/Promise;", "runnerForTask", "Lcom/jetbrains/cidr/execution/build/runners/CidrTaskRunner;", "task", "intellij.cidr.execution"})
public abstract class CidrProjectTaskRunner
extends ProjectTaskRunner {
    @NonNls
    @NotNull
    public abstract String getBuildSystemId();

    @NotNull
    public Promise<ProjectTaskRunner.Result> run(@NotNull Project project, @NotNull ProjectTaskContext context, ProjectTask ... tasks2) {
        if (project.isDisposed()) {
            return Promises.rejectedPromise((String)"Project is already disposed");
        }
        AsyncPromise resultPromise = new AsyncPromise();
        Object object = context.getSessionId();
        if (object == null) {
            object = UUID.randomUUID();
        }
        Object sessionId = object;
        FutureResult waitingIndicator = new FutureResult();
        BackgroundableProjectTaskRunner queuedTask = new BackgroundableProjectTaskRunner(project, tasks2, this, (AsyncPromise<ProjectTaskRunner.Result>)resultPromise, sessionId, context, (Future)waitingIndicator);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            new WaitingTask(project, (FutureResult<ProgressIndicator>)waitingIndicator, (Future)queuedTask.getExecutionStarted()).queue();
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<CidrBuildSessionsQueueManager> serviceClass$iv = CidrBuildSessionsQueueManager.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        ((CidrBuildSessionsQueueManager)object2).buildQueue(this.getBuildSystemId()).run((Task.Backgroundable)queuedTask, ModalityState.NON_MODAL, (ProgressIndicator)new EmptyProgressIndicator());
        return (Promise)resultPromise;
    }

    @Nullable
    public abstract CidrTaskRunner runnerForTask(@NotNull ProjectTask var1, @NotNull Project var2);
}

