/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.NlsActions;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.jetbrains.cidr.execution.CidrProjectTaskContextProvider;
import com.jetbrains.cidr.execution.build.CidrBuildConfigurationProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H%J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0014J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/execution/build/CidrAbstractBuildTargetAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "isIncrementalBuild", "", "title", "", "description", "icon", "Ljavax/swing/Icon;", "(ZLjava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "buildText", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "createContext", "Lcom/intellij/task/ProjectTaskContext;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getBuildableElements", "", "Lcom/intellij/openapi/roots/ProjectModelBuildableElement;", "isEnabled", "isVisible", "update", "intellij.cidr.execution"})
public abstract class CidrAbstractBuildTargetAction
extends DumbAwareAction {
    private final boolean isIncrementalBuild;

    public CidrAbstractBuildTargetAction(boolean isIncrementalBuild, @NlsActions.ActionText @Nullable String title, @NlsActions.ActionDescription @Nullable String description2, @Nullable Icon icon) {
        super(title, description2, icon);
        this.isIncrementalBuild = isIncrementalBuild;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = DumbAwareAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean isEnabled = this.isEnabled(project);
        e.getPresentation().setVisible(this.isVisible(isEnabled));
        e.getPresentation().setEnabled(isEnabled);
        RunManager runManager = RunManager.Companion.getInstanceIfCreated(project);
        RunConfiguration configuration = runManager != null && (runManager = runManager.getSelectedConfiguration()) != null ? runManager.getConfiguration() : null;
        e.getPresentation().setText(this.buildText(configuration), false);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = DumbAwareAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        Project project2 = project;
        List<ProjectModelBuildableElement> buildableElements = this.getBuildableElements(project2);
        if (buildableElements.isEmpty()) {
            return;
        }
        ProjectTaskContext context = this.createContext(project2, e.getDataContext());
        ProjectTaskManager manager2 = ProjectTaskManager.getInstance((Project)project2);
        Collection $this$toTypedArray$iv = buildableElements;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ProjectModelBuildableElement[] projectModelBuildableElementArray = thisCollection$iv.toArray(new ProjectModelBuildableElement[0]);
        manager2.run(context, manager2.createBuildTask(this.isIncrementalBuild, Arrays.copyOf(projectModelBuildableElementArray, projectModelBuildableElementArray.length)));
    }

    protected boolean isEnabled(@NotNull Project project) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = CidrBuildConfigurationProvider.EP_NAME.getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CidrBuildConfigurationProvider it = (CidrBuildConfigurationProvider)element$iv;
                    boolean bl2 = false;
                    if (!(it.hasBuildableConfigurations(project) && (this.isIncrementalBuild || it.hasCleanableConfigurations(project)))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected boolean isVisible(boolean isEnabled) {
        return true;
    }

    @NotNull
    protected List<ProjectModelBuildableElement> getBuildableElements(@NotNull Project project) {
        List<ProjectModelBuildableElement> list;
        List<ProjectModelBuildableElement> buildableConfigurations;
        Object v0;
        block2: {
            Iterable iterable = CidrBuildConfigurationProvider.EP_NAME.getExtensionList();
            for (Object t : iterable) {
                CidrBuildConfigurationProvider it = (CidrBuildConfigurationProvider)t;
                boolean bl = false;
                if (!it.hasBuildableConfigurations(project)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        CidrBuildConfigurationProvider cidrBuildConfigurationProvider = v0;
        List<ProjectModelBuildableElement> list2 = buildableConfigurations = cidrBuildConfigurationProvider != null && (list = cidrBuildConfigurationProvider.getBuildableConfigurations(project)) != null ? list : CollectionsKt.emptyList();
        if (buildableConfigurations.isEmpty()) {
            new EditConfigurationsDialog(project).show();
        }
        return buildableConfigurations;
    }

    @NotNull
    protected ProjectTaskContext createContext(@NotNull Project project, @NotNull DataContext dataContext) {
        return CidrProjectTaskContextProvider.Companion.createContext(project, dataContext);
    }

    @Nls
    @NotNull
    protected abstract String buildText(@Nullable RunConfiguration var1);
}

