/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.application.ReadAction;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.CidrLog;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfigurationBuildConfigurationEditor;
import com.jetbrains.cidr.ui.ComboBoxModelKt;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NoUIEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
implements CidrRunConfigurationBuildConfigurationEditor {
    @NotNull
    private final BCH myConfigHelper;
    @NotNull
    private final JComboBox myTargetCombo;

    NoUIEditor(@NotNull BCH configHelper, @NotNull JComboBox targetCombo) {
        CidrLog.LOG.assertTrue(!((CidrBuildConfigurationHelper)configHelper).allowEditBuildConfiguration());
        this.myConfigHelper = configHelper;
        this.myTargetCombo = targetCombo;
    }

    @Override
    public void createAdditionalControls(@NotNull JPanel panel, @NotNull GridBag bag) {
    }

    @Override
    @Nullable
    public String getSelectedConfiguration() {
        CidrBuildTarget selectedBuildTarget = (CidrBuildTarget)ComboBoxModelKt.getSelectedItemValue(this.myTargetCombo);
        return (String)ReadAction.compute(() -> {
            Object defaultConfiguration = ((CidrBuildConfigurationHelper)this.myConfigHelper).getDefaultConfiguration((CidrBuildTarget)selectedBuildTarget);
            return defaultConfiguration != null ? defaultConfiguration.getName() : null;
        });
    }

    @Override
    public void selectConfiguration(@Nullable Object item, @Nullable Object invalidItemValue) {
    }
}

