/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationProducer;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrTargetConfigurationHelper;
import com.jetbrains.cidr.execution.CidrTargetRunConfigurationBinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class CidrTargetRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>>
extends CidrContextRunConfigurationProducer<BC, TARGET, CONFIGURATION> {
    private static List<CidrTargetRunConfigurationProducer> INSTANCES = null;

    protected CidrTargetRunConfigurationProducer(@NotNull CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> binder) {
        super(binder);
    }

    protected boolean setupConfigurationFromContext(@NotNull CONFIGURATION newConfigurationWithTemplateDefaults, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        BuildTargetAndConfigurationData btc;
        Location location = context.getLocation();
        if (location != null && CidrTargetRunConfigurationProducer.isEntryPointBody(location) && (btc = this.findBuiltTargetAndConfiguration(newConfigurationWithTemplateDefaults, this.getExecutableTargetsForFile(location.getPsiElement().getContainingFile()), true)) != null) {
            if (btc.target != null) {
                newConfigurationWithTemplateDefaults.setName(btc.target.targetName);
            }
            return true;
        }
        return false;
    }

    public boolean isConfigurationFromContext(@NotNull CONFIGURATION savedConfiguration, @NotNull ConfigurationContext context) {
        Location location = context.getLocation();
        if (location != null && CidrTargetRunConfigurationProducer.isEntryPointBody(location) && this.getConfigurationType().equals(savedConfiguration.getType())) {
            BuildTargetAndConfigurationData fromContext = this.findBuiltTargetAndConfiguration(savedConfiguration, this.getExecutableTargetsForFile(location.getPsiElement().getContainingFile()), false);
            BuildTargetAndConfigurationData saved = ((CidrRunConfiguration)savedConfiguration).getTargetAndConfigurationData();
            return saved != null && fromContext != null && Objects.equals(saved.target, fromContext.target);
        }
        return false;
    }

    private static boolean isEntryPointBody(@NotNull Location location) {
        return CidrTargetConfigurationHelper.EP_NAME.getExtensionList().stream().anyMatch(helper -> helper.isInEntryPointBody(location));
    }

    @NotNull
    public static synchronized List<CidrTargetRunConfigurationProducer> getInstances(@NotNull Project project) {
        if (INSTANCES != null) {
            return INSTANCES;
        }
        List producers = RunConfigurationProducer.getProducers((Project)project);
        INSTANCES = new ArrayList<CidrTargetRunConfigurationProducer>();
        for (RunConfigurationProducer cp : producers) {
            if (!(cp instanceof CidrTargetRunConfigurationProducer)) continue;
            INSTANCES.add((CidrTargetRunConfigurationProducer)cp);
        }
        return INSTANCES;
    }
}

