/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationEditorUtil;
import com.jetbrains.cidr.execution.CidrRunConfigurationUtil;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.ui.ComboBoxModelKt;
import com.jetbrains.cidr.ui.CustomEditableComboItem;
import com.jetbrains.cidr.ui.ExecutableDataPrinter;
import com.jetbrains.cidr.ui.FileItemPrinter;
import com.jetbrains.cidr.ui.InvalidItem;
import com.jetbrains.cidr.ui.ItemPrinter;
import com.jetbrains.cidr.ui.ItemPrinterKt;
import com.jetbrains.cidr.ui.MutableComboBoxModelEx;
import com.jetbrains.cidr.ui.SortedCollectionComboBoxModel;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrRunConfigurationExecutableEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>> {
    private final BCH myConfigHelper;
    private final ComboboxWithBrowseButton myComboboxWithBrowseButton;
    private final MutableComboBoxModelEx<Object> myExecutableComboModel;
    private final CustomEditableComboItem customExecutableItem = new CustomEditableComboItem(CidrExecutionBundle.message("custom.executable.title", new Object[0]));

    public CidrRunConfigurationExecutableEditor(Project project, @NotNull BCH configHelper, boolean hasTargetsInSeveralProjects) {
        this.myConfigHelper = configHelper;
        this.myExecutableComboModel = new SortedCollectionComboBoxModel<Object>(ComparisonsKt.compareBy((Function1[])new Function1[]{o -> {
            if (o == null) {
                return Integer.valueOf(0);
            }
            if (o instanceof CidrBuildTarget) {
                return Integer.valueOf(1);
            }
            if (o instanceof InvalidItem) {
                return Integer.valueOf(2);
            }
            if (o instanceof File) {
                return Integer.valueOf(3);
            }
            return Integer.valueOf(4);
        }}));
        this.resetExecutableModel(null, null);
        this.myComboboxWithBrowseButton = new ComboboxWithBrowseButton((JComboBox)((Object)CidrRunConfigurationEditorUtil.createCombo(item -> item instanceof File || item instanceof String)));
        final JComboBox combobox = this.myComboboxWithBrowseButton.getComboBox();
        combobox.setModel(this.myExecutableComboModel);
        combobox.setRenderer(new MyExecutablesRenderer(hasTargetsInSeveralProjects, ItemPrinterKt.printerFor(CustomEditableComboItem.class, (renderer, item, state) -> renderer.appendGrayed(item, state))));
        combobox.addActionListener(evt -> {
            String content;
            if (combobox.getSelectedItem() instanceof String && (content = (String)combobox.getSelectedItem()).isEmpty()) {
                combobox.setSelectedItem(null);
            }
        });
        this.myComboboxWithBrowseButton.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JComboBox>(CidrExecutionBundle.message("executable.select.title", new Object[0]), null, (ComponentWithBrowseButton)this.myComboboxWithBrowseButton, null, FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor(), TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                combobox.getModel().setSelectedItem(VfsUtilCore.virtualToIoFile((VirtualFile)chosenFile));
            }
        });
        MessageBus messageBus = project.getMessageBus();
        combobox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                String itemName = CidrRunConfigurationExecutableEditor.getItemName(ComboBoxModelKt.getItemValue(e));
                ((ExecutableListener)messageBus.syncPublisher(ExecutableListener.TOPIC)).onExecutableSelected(itemName);
            }
        });
    }

    protected void resetExecutableModel(@Nullable Object selection, @Nullable TARGET buildTarget) {
        ArrayList<Object> newItems = new ArrayList<Object>();
        newItems.add(this.customExecutableItem);
        newItems.addAll(((CidrBuildConfigurationHelper)this.myConfigHelper).getRunTargets(buildTarget));
        if (selection != null && !newItems.contains(selection)) {
            newItems.add(selection);
        }
        this.myExecutableComboModel.reset(newItems);
        this.myExecutableComboModel.setSelectedItem(selection);
    }

    public void createAdditionalControls(JPanel panel, GridBag g) {
        JLabel label = new JLabel(((CidrBuildConfigurationHelper)this.myConfigHelper).getExecutableTitle() + ":");
        panel.add((Component)label, g.nextLine().next());
        panel.add((Component)this.myComboboxWithBrowseButton, g.next().coverLine());
        label.setLabelFor((Component)this.myComboboxWithBrowseButton);
    }

    public void onTargetSelected(@Nullable TARGET target) {
        if (target != null && target.isExecutable()) {
            this.myComboboxWithBrowseButton.getComboBox().setSelectedItem(null);
            this.myComboboxWithBrowseButton.getComboBox().setSelectedItem(target);
        }
    }

    public void resetEditorFrom(@NotNull CONFIGURATION runConfiguration) {
        ExecutableData executableData = ((CidrExecutableDataHolder)runConfiguration).getExecutableData();
        Object executable = ((CidrExecutableDataHolder)runConfiguration).getExecutableData();
        if (executableData != null) {
            if (executableData.target != null) {
                executable = ((CidrBuildConfigurationHelper)this.myConfigHelper).findRunTarget(executableData.target);
            } else if (executableData.path != null) {
                executable = new File(executableData.path);
            }
        }
        CidrBuildTarget<?> target = CidrRunConfigurationUtil.getTarget(runConfiguration);
        this.resetExecutableModel(ComboBoxModelKt.createMaybeInvalidItem(executable, executableData), target);
    }

    public void applyEditorTo(@NotNull CONFIGURATION runConfiguration) throws ConfigurationException {
        ExecutableData executableData = ((CidrExecutableDataHolder)runConfiguration).getExecutableData();
        JComboBox combobox = this.myComboboxWithBrowseButton.getComboBox();
        Object selectedExecutable = ComboBoxModelKt.getSelectedItemValue(combobox);
        if (combobox.isEditable() && combobox.getEditor().getItem() instanceof String) {
            String content = (String)combobox.getEditor().getItem();
            executableData = content.isBlank() ? null : new ExecutableData(content);
        } else if (selectedExecutable == null) {
            executableData = (ExecutableData)ComboBoxModelKt.getSelectedInvalidItemValue(combobox);
        } else if (selectedExecutable instanceof CidrBuildTarget) {
            executableData = new ExecutableData(new BuildTargetData((CidrBuildTarget)selectedExecutable));
        } else if (selectedExecutable instanceof File) {
            executableData = new ExecutableData(((File)selectedExecutable).getPath());
        } else if (selectedExecutable instanceof String) {
            executableData = new ExecutableData((String)selectedExecutable);
        }
        ((CidrExecutableDataHolder)runConfiguration).setExecutableData(executableData);
    }

    @Nullable
    private static String getItemName(Object item) {
        if (item instanceof File) {
            return ((File)item).getName();
        }
        if (item instanceof CidrBuildTarget) {
            return ((CidrBuildTarget)item).getName();
        }
        return null;
    }

    public ComboboxWithBrowseButton getComboboxWithBrowseButton() {
        return this.myComboboxWithBrowseButton;
    }

    private static class MyExecutablesRenderer
    extends CidrRunConfigurationEditorUtil.RunConfigurationsRenderer {
        MyExecutablesRenderer(boolean hasTargetsInSeveralProjects, ItemPrinter ... itemPrinters) {
            super(hasTargetsInSeveralProjects, MyExecutablesRenderer.arrayOf(itemPrinters, new FileItemPrinter(true, true), ExecutableDataPrinter.INSTANCE));
        }

        protected String getSeparatorAbove(@NotNull JList list, Object value, int index) {
            if (index == 0) {
                return null;
            }
            if (value instanceof CustomEditableComboItem) {
                return "";
            }
            Object previous = list.getModel().getElementAt(index - 1);
            if (value instanceof File && !(previous instanceof File)) {
                return "";
            }
            return super.getSeparatorAbove(list, value, index);
        }
    }

    public static interface ExecutableListener {
        public static final Topic<ExecutableListener> TOPIC = new Topic(ExecutableListener.class.getSimpleName(), ExecutableListener.class);

        public void onExecutableSelected(@Nullable String var1);
    }
}

