/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.util.Comparing;
import com.jetbrains.cidr.CidrRunnerBundle;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.ui.ActionItemsComboBox;
import com.jetbrains.cidr.ui.BaseListRenderer;
import com.jetbrains.cidr.ui.BuildConfigurationPrinter;
import com.jetbrains.cidr.ui.BuildTargetPrinter;
import com.jetbrains.cidr.ui.ComboBoxModelKt;
import com.jetbrains.cidr.ui.ItemPrinter;
import com.jetbrains.cidr.ui.ItemState;
import java.util.function.Predicate;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrRunConfigurationEditorUtil {
    @NotNull
    public static ComboBox createCombo() {
        return new ComboBox();
    }

    @NotNull
    public static ComboBox createCombo(@NotNull Predicate<Object> isItemEditablePredicate) {
        return new ComboBox(isItemEditablePredicate);
    }

    @NotNull
    public static RunConfigurationsRenderer getTargetsRenderer(@NotNull CidrBuildConfigurationHelper helper) {
        return new RunConfigurationsRenderer(helper.hasTargetsInSeveralProjects(), new ItemPrinter[0]);
    }

    public static void setSelectedItem(@NotNull JComboBox combo, @Nullable Object item, @Nullable Object invalidItemValue) {
        item = ComboBoxModelKt.createMaybeInvalidItem(item, invalidItemValue);
        boolean exists = false;
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (!Comparing.equal((Object)item, combo.getItemAt(i))) continue;
            exists = true;
            break;
        }
        if (!exists) {
            combo.addItem(item);
        }
        combo.setSelectedItem(item);
    }

    public static class ComboBox
    extends ActionItemsComboBox<String> {
        ComboBox() {
        }

        ComboBox(@NotNull Predicate<Object> isItemEditablePredicate) {
            super((__, selectedItem) -> isItemEditablePredicate.test(selectedItem));
        }

        public void fireSelectedItemChanged() {
            this.selectedItemChanged();
        }
    }

    public static class RunConfigurationsRenderer
    extends BaseListRenderer {
        public RunConfigurationsRenderer(boolean hasTargetsInSeveralProjects, ItemPrinter ... itemPrinters) {
            super(RunConfigurationsRenderer.arrayOf(itemPrinters, new BuildTargetPrinter(hasTargetsInSeveralProjects), new BuildConfigurationPrinter()));
        }

        @Override
        public void appendError(@Nullable Object value, @NotNull ItemState state) {
            super.appendError(value, state);
            String message = this.isChecking() ? CidrRunnerBundle.message("test.configuration.checking", new Object[0]) : CidrRunnerBundle.message("build.configuration.dialog.item.parameterNotFound", new Object[0]);
            this.appendGrayed(" (" + message + ")", state);
        }

        protected boolean isChecking() {
            return false;
        }
    }
}

