/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.cidr.execution.CidrRestartActionProvider;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CidrLauncher {
    public ProcessHandler startProcess(@NotNull CommandLineState state) throws ExecutionException {
        return this.createProcess(state);
    }

    protected abstract ProcessHandler createProcess(@NotNull CommandLineState var1) throws ExecutionException;

    @NotNull
    public XDebugProcess startDebugProcess(@NotNull CommandLineState state, @NotNull XDebugSession session) throws ExecutionException {
        XDebugProcess result = this.createDebugProcess(state, session);
        if (result instanceof CidrDebugProcess) {
            CidrDebugProcess cidrDebugProcess = (CidrDebugProcess)result;
            if (session instanceof XDebugSessionImpl) {
                XDebugSessionImpl sessionImpl = (XDebugSessionImpl)session;
                sessionImpl.addRestartActions(this.getAdditionalActions(state, cidrDebugProcess.getProcessHandler(), (ExecutionConsole)cidrDebugProcess.getConsole()));
            }
            cidrDebugProcess.start();
        }
        return result;
    }

    @NotNull
    protected abstract XDebugProcess createDebugProcess(@NotNull CommandLineState var1, @NotNull XDebugSession var2) throws ExecutionException;

    protected static void configProcessHandler(@NotNull ProcessHandler handler, boolean detachSupported, boolean reportExitCode, @NotNull Project project) throws ExecutionException {
        if (!detachSupported) {
            handler.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)Boolean.TRUE);
        }
        if (reportExitCode) {
            ProcessTerminatedListener.attach((ProcessHandler)handler, (Project)project);
        }
    }

    @NotNull
    public abstract Project getProject();

    public void configureExecutionResult(@NotNull CommandLineState state, @NotNull DefaultExecutionResult executionResult) throws ExecutionException {
        executionResult.setRestartActions(this.getAdditionalActions(state, executionResult.getProcessHandler(), executionResult.getExecutionConsole()));
    }

    private AnAction @NotNull [] getAdditionalActions(@NotNull CommandLineState state, ProcessHandler handler, ExecutionConsole console) throws ExecutionException {
        ArrayList actions = new ArrayList();
        this.collectAdditionalActions(state, handler, console, actions);
        return actions.toArray(AnAction.EMPTY_ARRAY);
    }

    protected void collectAdditionalActions(@NotNull CommandLineState state, @NotNull ProcessHandler processHandler, @NotNull ExecutionConsole console, @NotNull List<? super AnAction> actions) throws ExecutionException {
        if (state instanceof CidrRestartActionProvider) {
            actions.add((AnAction)((CidrRestartActionProvider)state).createRestartAction(console));
        }
    }
}

