/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.execution.CidrPathConsoleFilter;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDebugConsoleFilterProvider
implements ConsoleFilterProvider {
    @Nullable
    private final CidrToolEnvironment myEnvironment;
    @Nullable
    private final Path myBaseDir;

    public CidrDebugConsoleFilterProvider(@Nullable CidrToolEnvironment environment, @Nullable Path baseDir) {
        this.myEnvironment = environment;
        this.myBaseDir = baseDir;
    }

    @Nullable
    public static File getProjectBaseDir(@NotNull Project project) {
        VirtualFile baseDir = project.getBaseDir();
        return baseDir == null ? null : VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
    }

    public Filter @NotNull [] getDefaultFilters(@NotNull Project project) {
        CidrPathConsoleFilter pathFilter = new CidrPathConsoleFilter(project, this.myEnvironment, this.myBaseDir);
        return new Filter[]{pathFilter};
    }
}

