/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildConfigurationProblems {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String title = "";
    public final @NotNull List<@NlsContexts.DialogMessage String> problems = new SmartList();
    public final @NotNull List<@NlsContexts.DialogMessage String> warnings = new SmartList();
    @NotNull
    public final List<Fix> fixes = new SmartList();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @NotNull
    @Nls
    public List<String> getProblems() {
        return this.problems;
    }

    public boolean hasProblems() {
        return !this.problems.isEmpty();
    }

    @NotNull
    @NlsContexts.DialogMessage
    public String getHtmlProblems() {
        return StringUtil.join(this.problems, (String)"<br>");
    }

    @NotNull
    @NlsContexts.DialogMessage
    public String getTextProblems() {
        return StringUtil.join(this.problems, (String)"\n");
    }

    @NotNull
    @NlsContexts.DialogMessage
    public String getText() {
        Object result = this.getTitle();
        if (this.hasProblems()) {
            result = (String)result + "\n" + this.getTextProblems();
        }
        return result;
    }

    public @NotNull List<@NlsContexts.DialogMessage String> getWarnings() {
        return this.warnings;
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    @NotNull
    @NlsContexts.DialogMessage
    public String getHtmlWarnings() {
        return StringUtil.join(this.warnings, (String)"<br>");
    }

    public void throwAsConfigurationExceptions() throws RuntimeConfigurationException {
        if (this.hasProblems()) {
            throw new RuntimeConfigurationError(this.getHtmlProblems());
        }
        if (this.hasWarnings()) {
            throw new RuntimeConfigurationWarning(this.getHtmlWarnings());
        }
    }

    @NotNull
    public List<Fix> getFixes() {
        return this.fixes;
    }

    @Nullable
    public Fix findFix(@Nullable String name) {
        for (Fix each : this.fixes) {
            if (!each.name.equals(name)) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public BuildConfigurationProblems join(@NotNull BuildConfigurationProblems that) {
        if (this.title.isEmpty() && !that.title.isEmpty()) {
            this.title = that.title;
        }
        this.warnings.addAll(that.warnings);
        this.problems.addAll(that.problems);
        this.fixes.addAll(that.fixes);
        return this;
    }

    public static abstract class Fix {
        @NotNull
        private final String name;

        protected Fix(@NotNull String name) {
            this.name = name;
        }

        public abstract void apply();

        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

