/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenProjectTaskKt;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.jetbrains.cidr.CidrProjectApplicationVersion;
import com.jetbrains.cidr.EarlyProjectDirListener;
import java.nio.file.Path;
import java.util.function.Predicate;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectOpenHelper<T> {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ProjectOpenHelper.class);
    private final Key<T> myOpenDataKey;
    private final SupportedFileChecker mySupportedFileChecker;

    public ProjectOpenHelper(@NotNull Key<T> openDataKey, @NotNull SupportedFileChecker supportedFileChecker) {
        this.myOpenDataKey = openDataKey;
        this.mySupportedFileChecker = supportedFileChecker;
    }

    public boolean isSupportedFile(@Nullable VirtualFile file) {
        return file != null && this.mySupportedFileChecker.isSupportedFile(file);
    }

    @Nullable
    public VirtualFile findSupportedSubFile(@NotNull VirtualFile file) {
        if (!file.isDirectory() && this.isSupportedFile(file)) {
            return file;
        }
        for (VirtualFile child : file.getChildren()) {
            if (child == null || child.isDirectory() || !this.isSupportedFile(child)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getValidProjectPath(@NotNull VirtualFile file) {
        if (!file.isDirectory()) {
            file = file.getParent();
        }
        if (ProjectUtil.isValidProjectPath((Path)file.toNioPath())) {
            return file;
        }
        return null;
    }

    @Nullable
    private static Pair<Path, OpenProjectTask> createTaskToOpenExistingProjectInDirectory(@NotNull VirtualFile file, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        VirtualFile projectDir = ProjectOpenHelper.getValidProjectPath(file);
        if (projectDir == null) {
            return null;
        }
        LOG.info("Opening existing project in directory " + projectDir + " Requested file " + file);
        Path projectPath = projectDir.toNioPath();
        OpenProjectTask openProjectTask = PlatformProjectOpenProcessor.createOptionsToOpenDotIdeaOrCreateNewIfNotExists((Path)projectPath, (Project)projectToClose).withForceOpenInNewFrame(forceOpenInNewFrame);
        return new Pair((Object)projectPath, (Object)openProjectTask);
    }

    @Nullable
    public Project openExistingProjectInDirectory(@NotNull VirtualFile file, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Pair<Path, OpenProjectTask> task = ProjectOpenHelper.createTaskToOpenExistingProjectInDirectory(file, projectToClose, forceOpenInNewFrame);
        if (task == null) {
            return null;
        }
        return ProjectManagerEx.getInstanceEx().openProject((Path)task.first, (OpenProjectTask)task.second);
    }

    @Nullable
    public Project openProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, T data) {
        return this.openProject(virtualFile, projectToClose, forceOpenInNewFrame, data, project -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Project openProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, T data, Predicate<Project> callback) {
        if (!this.isSupportedFile(virtualFile)) {
            return null;
        }
        this.markFileToOpen(virtualFile, data);
        VirtualFile baseDir = virtualFile.getParent();
        OpenProjectTask options = OpenProjectTaskKt.OpenProjectTask(builder -> {
            PlatformProjectOpenProcessor.Companion.configureToOpenDotIdeaOrCreateNewIfNotExists(builder, baseDir.toNioPath(), projectToClose);
            builder.setForceOpenInNewFrame(forceOpenInNewFrame);
            builder.withBeforeOpenCallback(ProjectOpenHelper.beforeOpenCallback(callback));
            return Unit.INSTANCE;
        });
        EarlyProjectDirListener dirListener = (EarlyProjectDirListener)ApplicationManager.getApplication().getService(EarlyProjectDirListener.class);
        if (dirListener != null) {
            dirListener.setBaseDir(baseDir.getCanonicalPath());
        }
        try {
            Project project = ProjectManagerEx.getInstanceEx().openProject(baseDir.toNioPath(), options);
            return project;
        }
        finally {
            if (dirListener != null) {
                dirListener.setBaseDir(null);
            }
        }
    }

    public void linkToExistingProject(@NotNull Project project, @NotNull T data) {
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile userDataHolder = baseDir != null ? baseDir : project;
        userDataHolder.putUserData(this.myOpenDataKey, data);
    }

    @NotNull
    private static Predicate<Project> beforeOpenCallback(@Nullable Predicate<Project> userCallback) {
        return project -> {
            CidrProjectApplicationVersion.getInstance(project).initializeApplicationInfo();
            return userCallback == null || userCallback.test((Project)project);
        };
    }

    public void markFileToOpen(@NotNull VirtualFile virtualFile, @NotNull T data) {
        VirtualFile baseDir = virtualFile.getParent();
        baseDir.putUserData(this.myOpenDataKey, data);
    }

    @Nullable
    public T getAndClearFileToOpenData(@NotNull Project project) {
        VirtualFile baseDir = project.getBaseDir();
        Object data = null;
        if (baseDir != null) {
            data = baseDir.getUserData(this.myOpenDataKey);
            baseDir.putUserData(this.myOpenDataKey, null);
        }
        if (data == null) {
            data = project.getUserData(this.myOpenDataKey);
        }
        project.putUserData(this.myOpenDataKey, null);
        return (T)data;
    }

    public static interface SupportedFileChecker {
        public boolean isSupportedFile(@NotNull VirtualFile var1);
    }
}

