/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.util;

import com.intellij.cidr.cpp.util.CidrIntType;
import com.intellij.cidr.cpp.util.CidrStringLiteralUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class CidrStringLiteral {
    @NotNull
    public final CidrStringLiteralUtil.CidrStringPrefix prefix;
    @NotNull
    public final String contents;

    public CidrStringLiteral(@NotNull CidrStringLiteralUtil.CidrStringPrefix prefix, @NotNull String contents) {
        this.prefix = prefix;
        this.contents = contents;
    }

    public String getContents(boolean escaped) {
        if (this.prefix.isRaw != escaped) {
            return this.contents;
        }
        if (escaped) {
            return StringUtil.escapeStringCharacters((String)this.contents);
        }
        return StringUtil.unescapeAnsiStringCharacters((String)this.contents);
    }

    @NotNull
    public CidrIntType getElementType(boolean isPlainOldC) {
        return isPlainOldC ? this.prefix.charTypePlainC : this.prefix.charTypeCpp;
    }

    public int getContentLengthInCharacters() {
        String unescapedContents = this.getContents(false);
        if (this.prefix.encoding == CidrStringLiteralUtil.CidrEncoding.UTF8) {
            byte[] encodedContents = this.prefix.encoding.getBytes(unescapedContents);
            return encodedContents.length;
        }
        return unescapedContents.length();
    }

    public String toString() {
        return "CidrStringLiteral{prefix=" + this.prefix + ", contents='" + this.contents + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CidrStringLiteral literal = (CidrStringLiteral)o;
        if (this.prefix != literal.prefix) {
            return false;
        }
        return this.contents.equals(literal.contents);
    }

    public int hashCode() {
        int result = this.prefix.hashCode();
        result = 31 * result + this.contents.hashCode();
        return result;
    }
}

