/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.lexer;

import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NonNls;

public class CidrStringLiteralLexer
extends StringLiteralLexer {
    public static final char LONG_UNICODE_ESCAPE_CHAR = 'U';
    public static final int LONG_UNICODE_ESCAPE_SEQUENCE_LENGTH = 10;
    @NonNls
    public static final String ADDITIONAL_VALID_ESCAPES = "?abvU";

    public CidrStringLiteralLexer(char quoteChar, IElementType originalLiteralToken) {
        super(quoteChar, originalLiteralToken, false, ADDITIONAL_VALID_ESCAPES, true, true);
    }

    protected int locateAdditionalEscapeSequence(int start, int indexOfCharAfterSlash) {
        if (this.myBuffer.charAt(indexOfCharAfterSlash) == 'U') {
            int location;
            for (location = indexOfCharAfterSlash + 1; location < start + 10; ++location) {
                if (location != this.myBufferEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(location))) continue;
                return location;
            }
            return location;
        }
        return -1;
    }

    public IElementType getTokenType() {
        IElementType type = super.getTokenType();
        if (type == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN && this.myBuffer.charAt(this.myStart + 1) == 'U' && this.myEnd - this.myStart != 10) {
            return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
        }
        return type;
    }
}

