/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.packaging.jlink;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.annotations.OptionTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.ex.JpsElementBase;

final class JpsJLinkProperties
extends JpsElementBase<JpsJLinkProperties> {
    @OptionTag(converter=CompressionLevelConverter.class)
    public CompressionLevel compressionLevel = CompressionLevel.ZERO;
    public boolean verbose;

    JpsJLinkProperties() {
    }

    JpsJLinkProperties(@NotNull JpsJLinkProperties properties) {
        this.copyToThis(properties);
    }

    JpsJLinkProperties(@NotNull CompressionLevel compressionLevel, boolean verbose) {
        this.compressionLevel = compressionLevel;
        this.verbose = verbose;
    }

    @NotNull
    public JpsJLinkProperties createCopy() {
        return new JpsJLinkProperties(this);
    }

    public void applyChanges(@NotNull JpsJLinkProperties modified) {
        this.copyToThis(modified);
    }

    private void copyToThis(@NotNull JpsJLinkProperties copy) {
        this.compressionLevel = copy.compressionLevel;
        this.verbose = copy.verbose;
    }

    static enum CompressionLevel {
        ZERO(0),
        FIRST(1),
        SECOND(2);

        final int myValue;

        private CompressionLevel(int value) {
            this.myValue = value;
        }

        boolean hasCompression() {
            return this == FIRST || this == SECOND;
        }
    }

    private static final class CompressionLevelConverter
    extends Converter<CompressionLevel> {
        private CompressionLevelConverter() {
        }

        @Nullable
        public CompressionLevel fromString(@NotNull String value) {
            int levelVal;
            try {
                levelVal = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
            return (CompressionLevel)((Object)ContainerUtil.find((Object[])CompressionLevel.values(), level -> level.myValue == levelVal));
        }

        @NotNull
        public String toString(@NotNull CompressionLevel value) {
            return String.valueOf(value.myValue);
        }
    }
}

