/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public class SourceToOutputMappingImpl
implements SourceToOutputMapping,
StorageOwner {
    private final OneToManyPathsMapping myMapping;

    public SourceToOutputMappingImpl(File storePath, PathRelativizerService relativizer) throws IOException {
        this.myMapping = new OneToManyPathsMapping(storePath, relativizer);
    }

    @Override
    public void setOutputs(@NotNull String srcPath, @NotNull Collection<String> outputs) throws IOException {
        this.myMapping.update(srcPath, outputs);
    }

    @Override
    public void setOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
        this.myMapping.update(srcPath, outputPath);
    }

    @Override
    public void appendOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
        this.myMapping.appendData(srcPath, outputPath);
    }

    @Override
    public void remove(@NotNull String srcPath) throws IOException {
        this.myMapping.remove(srcPath);
    }

    @Override
    public void removeOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
        this.myMapping.removeData(srcPath, outputPath);
    }

    @Override
    @NotNull
    public Collection<String> getSources() throws IOException {
        return this.myMapping.getKeys();
    }

    @Override
    @Nullable
    public Collection<String> getOutputs(@NotNull String srcPath) throws IOException {
        return this.myMapping.getState(srcPath);
    }

    @Override
    @NotNull
    public Iterator<String> getOutputsIterator(@NotNull String srcPath) throws IOException {
        return this.myMapping.getStateIterator(srcPath);
    }

    @Override
    @NotNull
    public Iterator<String> getSourcesIterator() throws IOException {
        return this.myMapping.getKeysIterator();
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
        this.myMapping.flush(memoryCachesOnly);
    }

    @Override
    public void close() throws IOException {
        this.myMapping.close();
    }

    @Override
    public void clean() throws IOException {
        this.myMapping.clean();
    }
}

