/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.messages;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.messages.BuildMessage;

public class CompilerMessage
extends BuildMessage {
    private final String myCompilerName;
    private final long myProblemBeginOffset;
    private final long myProblemEndOffset;
    private final long myProblemLocationOffset;
    private final String mySourcePath;
    private final long myLine;
    private final long myColumn;
    private final Collection<String> myModuleNames = new HashSet<String>();

    @Deprecated
    public CompilerMessage(@NlsSafe @NotNull String compilerName, @NotNull Throwable internalError) {
        this(compilerName, BuildMessage.Kind.ERROR, CompilerMessage.getTextFromThrowable(internalError), null, -1L, -1L, -1L, -1L, -1L);
    }

    public CompilerMessage(@NlsSafe @NotNull String compilerName, BuildMessage.Kind kind, @Nls(capitalization=Nls.Capitalization.Sentence) String messageText) {
        this(compilerName, kind, messageText, null, -1L, -1L, -1L, -1L, -1L);
    }

    public CompilerMessage(@NlsSafe @NotNull String compilerName, BuildMessage.Kind kind, @Nls(capitalization=Nls.Capitalization.Sentence) String messageText, String sourcePath) {
        this(compilerName, kind, messageText, sourcePath, -1L, -1L, -1L, -1L, -1L);
    }

    public CompilerMessage(@NlsSafe @NotNull String compilerName, BuildMessage.Kind kind, @Nls(capitalization=Nls.Capitalization.Sentence) String messageText, @Nullable String sourcePath, long problemBeginOffset, long problemEndOffset, long problemLocationOffset, long locationLine, long locationColumn) {
        super(messageText, kind);
        this.myCompilerName = compilerName;
        this.myProblemBeginOffset = problemBeginOffset;
        this.myProblemEndOffset = problemEndOffset;
        this.myProblemLocationOffset = problemLocationOffset;
        this.mySourcePath = sourcePath != null && !sourcePath.isEmpty() ? sourcePath.replace(File.separatorChar, '/') : null;
        this.myLine = locationLine;
        this.myColumn = locationColumn;
    }

    @NotNull
    public String getCompilerName() {
        return this.myCompilerName;
    }

    @Nullable
    public String getSourcePath() {
        return this.mySourcePath;
    }

    public long getLine() {
        return this.myLine;
    }

    public long getColumn() {
        return this.myColumn;
    }

    public long getProblemBeginOffset() {
        return this.myProblemBeginOffset;
    }

    public long getProblemEndOffset() {
        return this.myProblemEndOffset;
    }

    public long getProblemLocationOffset() {
        return this.myProblemLocationOffset;
    }

    public void addModuleName(String moduleName) {
        this.myModuleNames.add(moduleName);
    }

    public Collection<String> getModuleNames() {
        return Collections.unmodifiableCollection(this.myModuleNames);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getCompilerName()).append(":").append(this.getKind().name()).append(":").append(super.toString());
        String path = this.getSourcePath();
        if (path != null) {
            builder.append("; file: ").append(path);
            long line = this.getLine();
            long column = this.getColumn();
            if (line >= 0L && column >= 0L) {
                builder.append(" at (").append(line).append(":").append(column).append(")");
            }
        }
        return builder.toString();
    }

    public static CompilerMessage createInternalCompilationError(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String compilerName, @NotNull Throwable t) {
        return new CompilerMessage(compilerName, t);
    }

    public static CompilerMessage createInternalBuilderError(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String compilerName, @NotNull Throwable t) {
        return new CompilerMessage(compilerName, BuildMessage.Kind.INTERNAL_BUILDER_ERROR, CompilerMessage.getTextFromThrowable(t));
    }

    @Override
    @Nls
    public String getMessageText() {
        return super.getMessageText();
    }

    @NlsSafe
    public static String getTextFromThrowable(Throwable t) {
        String message = t.getMessage();
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            message = t.getClass().getName();
        }
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return "Error: " + message + "\n" + writer.getBuffer();
    }
}

