/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.FileCollectionFactory;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.library.OrderedClassLibraryBuilder;
import com.thoughtworks.qdox.model.JavaModule;
import com.thoughtworks.qdox.model.JavaModuleDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.javac.Iterators;
import org.jetbrains.jps.javac.ModulePath;

public final class ModulePathSplitter {
    private final Map<File, ModuleInfo> myCache = Collections.synchronizedMap(FileCollectionFactory.createCanonicalFileMap());
    private static final Attributes.Name AUTOMATIC_MODULE_NAME = new Attributes.Name("Automatic-Module-Name");
    private static final Method myModuleFinderCreateMethod;
    private static final Method myFindAll;
    private static final Method myGetDescriptor;
    private static final Method myDescriptorName;
    private static final Method myRequiresName;
    private static final Method myDescriptorRequires;
    public static final Function<File, String> DEFAULT_MODULE_NAME_SEARCH;
    @NotNull
    private final Function<? super File, String> myModuleNameSearch;
    private static final Pattern NON_ALPHANUM;
    private static final Pattern REPEATING_DOTS;

    public ModulePathSplitter() {
        this(DEFAULT_MODULE_NAME_SEARCH);
    }

    public ModulePathSplitter(@NotNull Function<? super File, String> moduleNameSearch) {
        this.myModuleNameSearch = moduleNameSearch;
    }

    public Pair<ModulePath, Collection<File>> splitPath(File chunkModuleInfo, Set<? extends File> chunkOutputs, Collection<? extends File> path) {
        return this.splitPath(chunkModuleInfo, chunkOutputs, path, Collections.emptySet());
    }

    public Pair<ModulePath, Collection<File>> splitPath(File chunkModuleInfo, Set<? extends File> chunkOutputs, Collection<? extends File> path, Collection<String> addReads) {
        if (myModuleFinderCreateMethod == null) {
            return Pair.create((Object)ModulePath.create(path), Collections.emptyList());
        }
        ModulePath.Builder mpBuilder = ModulePath.newBuilder();
        ArrayList<File> classpath = new ArrayList<File>();
        Set<String> allRequired = this.collectRequired(chunkModuleInfo, Iterators.filter(path, file -> !chunkOutputs.contains(file)));
        allRequired.addAll(addReads);
        for (File file2 : path) {
            if (chunkOutputs.contains(file2)) {
                mpBuilder.add(null, file2);
                continue;
            }
            ModuleInfo info = this.getModuleInfo(file2);
            if (allRequired.contains(info.name)) {
                mpBuilder.add(info.isAutomaticExploded ? info.name : null, file2);
                continue;
            }
            classpath.add(file2);
        }
        return Pair.create((Object)mpBuilder.create(), Collections.unmodifiableList(classpath));
    }

    private static String normalizeModuleName(String fName) {
        if (fName != null) {
            fName = NON_ALPHANUM.matcher(fName).replaceAll(".");
            int len = (fName = REPEATING_DOTS.matcher(fName).replaceAll(".")).length();
            if (len > 0) {
                int end;
                int start = fName.startsWith(".") ? 1 : 0;
                int n = end = fName.endsWith(".") ? len - 1 : len;
                if (start > 0 || end < len) {
                    fName = fName.substring(start, end);
                }
            }
        }
        return fName;
    }

    private Set<String> collectRequired(File chunkModuleInfo, Iterable<? extends File> path) {
        HashSet<String> result = new HashSet<String>();
        JavaModuleDescriptor chunkDescr = new JavaProjectBuilder(new OrderedClassLibraryBuilder()).addSourceFolder(chunkModuleInfo.getParentFile()).getDescriptor();
        for (JavaModuleDescriptor.JavaRequires javaRequires : chunkDescr.getRequires()) {
            JavaModule rm = javaRequires.getModule();
            if (rm == null) continue;
            result.add(rm.getName());
        }
        for (File file : path) {
            result.addAll(this.getModuleInfo((File)file).requires);
        }
        return result;
    }

    @NotNull
    private ModuleInfo getModuleInfo(File f) {
        ModuleInfo info = this.myCache.get(f);
        if (info != null) {
            return info;
        }
        info = ModuleInfo.EMPTY;
        try {
            Object mf = myModuleFinderCreateMethod.invoke(null, new Object[]{new Path[]{f.toPath()}});
            Set moduleRefs = (Set)myFindAll.invoke(mf, new Object[0]);
            if (!moduleRefs.isEmpty()) {
                Iterator iterator = moduleRefs.iterator();
                if (iterator.hasNext()) {
                    Object moduleRef = iterator.next();
                    Object descriptor = myGetDescriptor.invoke(moduleRef, new Object[0]);
                    String moduleName = (String)myDescriptorName.invoke(descriptor, new Object[0]);
                    Set requires = (Set)myDescriptorRequires.invoke(descriptor, new Object[0]);
                    if (requires.isEmpty()) {
                        info = new ModuleInfo(moduleName, false);
                    } else {
                        HashSet<String> req = new HashSet<String>();
                        for (Object require : requires) {
                            req.add((String)myRequiresName.invoke(require, new Object[0]));
                        }
                        info = new ModuleInfo(moduleName, req);
                    }
                }
            } else {
                String explodedModuleName = this.deriveAutomaticModuleName(f);
                if (explodedModuleName != null) {
                    info = new ModuleInfo(explodedModuleName, true);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.myCache.put(f, info);
        return info;
    }

    private String deriveAutomaticModuleName(File dir) {
        if (dir.isDirectory()) {
            String string;
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(dir, "META-INF/MANIFEST.MF")));
            try {
                String name = new Manifest(is).getMainAttributes().getValue(AUTOMATIC_MODULE_NAME);
                string = name != null ? name : ModulePathSplitter.normalizeModuleName(this.myModuleNameSearch.apply(dir));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return ModulePathSplitter.normalizeModuleName(this.myModuleNameSearch.apply(dir));
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
            }
            is.close();
            return string;
        }
        return null;
    }

    static {
        Method of = null;
        Method findAll = null;
        Method getDescriptor = null;
        Method descriptorName = null;
        Method requiresName = null;
        Method descriptorRequires = null;
        try {
            Class<?> finderClass = Class.forName("java.lang.module.ModuleFinder");
            Class<?> descriptorClass = Class.forName("java.lang.module.ModuleDescriptor");
            Class<?> referenceClass = Class.forName("java.lang.module.ModuleReference");
            Class<?> requireClass = Class.forName("java.lang.module.ModuleDescriptor$Requires");
            of = finderClass.getDeclaredMethod("of", Path[].class);
            findAll = finderClass.getDeclaredMethod("findAll", new Class[0]);
            getDescriptor = referenceClass.getDeclaredMethod("descriptor", new Class[0]);
            descriptorName = descriptorClass.getDeclaredMethod("name", new Class[0]);
            descriptorRequires = descriptorClass.getDeclaredMethod("requires", new Class[0]);
            requiresName = requireClass.getDeclaredMethod("name", new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        myModuleFinderCreateMethod = of;
        myFindAll = findAll;
        myGetDescriptor = getDescriptor;
        myDescriptorName = descriptorName;
        myRequiresName = requiresName;
        myDescriptorRequires = descriptorRequires;
        DEFAULT_MODULE_NAME_SEARCH = file -> {
            String fName = file.getName();
            int dotIndex = fName.lastIndexOf(46);
            return dotIndex >= 0 ? fName.substring(0, dotIndex) : fName;
        };
        NON_ALPHANUM = Pattern.compile("[^A-Za-z0-9]");
        REPEATING_DOTS = Pattern.compile("(\\.)(\\1)+");
    }

    private static final class ModuleInfo {
        static final ModuleInfo EMPTY = new ModuleInfo(null, false);
        @Nullable
        final String name;
        @NotNull
        final Collection<String> requires;
        private final boolean isAutomaticExploded;

        ModuleInfo(@Nullable String name, boolean isAutomaticExploded) {
            this.name = name;
            this.requires = Collections.emptyList();
            this.isAutomaticExploded = isAutomaticExploded;
        }

        ModuleInfo(@Nullable String name, @NotNull Collection<String> requires) {
            this.name = name;
            this.requires = Collections.unmodifiableCollection(requires);
            this.isAutomaticExploded = false;
        }
    }
}

