/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import com.intellij.openapi.util.Condition;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreator;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilder;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootCopyingHandlerProvider;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.FileBasedArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.incremental.artifacts.instructions.FilterCopyHandler;
import org.jetbrains.jps.incremental.artifacts.instructions.JarBasedArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.SourceFileFilter;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.service.JpsServiceManager;

public class ArtifactInstructionsBuilderImpl
implements ArtifactInstructionsBuilder {
    private final Map<String, JarInfo> myJarByPath;
    private final List<ArtifactRootDescriptor> myDescriptors;
    private final ModuleExcludeIndex myRootsIndex;
    private final Iterable<ArtifactRootCopyingHandlerProvider> myCopyingHandlerProviders;
    private int myRootIndex;
    private final IgnoredFileIndex myIgnoredFileIndex;
    private final ArtifactBuildTarget myBuildTarget;
    private final JpsModel myModel;
    private final BuildDataPaths myBuildDataPaths;

    public ArtifactInstructionsBuilderImpl(@NotNull ModuleExcludeIndex rootsIndex, @NotNull IgnoredFileIndex ignoredFileIndex, @NotNull ArtifactBuildTarget target, @NotNull JpsModel model, @NotNull BuildDataPaths dataPaths) {
        this.myRootsIndex = rootsIndex;
        this.myIgnoredFileIndex = ignoredFileIndex;
        this.myBuildTarget = target;
        this.myModel = model;
        this.myBuildDataPaths = dataPaths;
        this.myJarByPath = new HashMap<String, JarInfo>();
        this.myDescriptors = new ArrayList<ArtifactRootDescriptor>();
        this.myCopyingHandlerProviders = JpsServiceManager.getInstance().getExtensions(ArtifactRootCopyingHandlerProvider.class);
    }

    public IgnoredFileIndex getIgnoredFileIndex() {
        return this.myIgnoredFileIndex;
    }

    public boolean addDestination(@NotNull ArtifactRootDescriptor descriptor) {
        this.myDescriptors.add(descriptor);
        return true;
    }

    public ModuleExcludeIndex getRootsIndex() {
        return this.myRootsIndex;
    }

    public boolean registerJarFile(@NotNull JarInfo jarInfo, @NotNull String outputPath) {
        if (this.myJarByPath.containsKey(outputPath)) {
            return false;
        }
        this.myJarByPath.put(outputPath, jarInfo);
        return true;
    }

    @Override
    @NotNull
    public List<ArtifactRootDescriptor> getDescriptors() {
        return this.myDescriptors;
    }

    public FileBasedArtifactRootDescriptor createFileBasedRoot(@NotNull File file, @NotNull SourceFileFilter filter, @NotNull DestinationInfo destinationInfo, FileCopyingHandler handler) {
        return new FileBasedArtifactRootDescriptor(file, filter, this.myRootIndex++, this.myBuildTarget, destinationInfo, handler);
    }

    @Override
    @NotNull
    public FileCopyingHandler createCopyingHandler(@NotNull File file, @NotNull JpsPackagingElement contextElement, @NotNull ArtifactCompilerInstructionCreator instructionCreator) {
        File targetDirectory = instructionCreator.getTargetDirectory();
        if (targetDirectory != null) {
            for (ArtifactRootCopyingHandlerProvider provider : this.myCopyingHandlerProviders) {
                FileCopyingHandler handler = provider.createCustomHandler(this.myBuildTarget.getArtifact(), file, targetDirectory, contextElement, this.myModel, this.myBuildDataPaths);
                if (handler == null) continue;
                return handler;
            }
        }
        return FilterCopyHandler.DEFAULT;
    }

    public JarBasedArtifactRootDescriptor createJarBasedRoot(@NotNull File jarFile, @NotNull String pathInJar, @NotNull SourceFileFilter filter, @NotNull DestinationInfo destinationInfo, @NotNull Condition<? super String> pathInJarFilter) {
        return new JarBasedArtifactRootDescriptor(jarFile, pathInJar, filter, this.myRootIndex++, this.myBuildTarget, destinationInfo, pathInJarFilter);
    }
}

