/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.PathStringDescriptor;

public class ArtifactOutputToSourceMapping
extends AbstractStateStorage<String, List<SourcePathAndRootIndex>> {
    private final PathRelativizerService myRelativizer;

    public ArtifactOutputToSourceMapping(File storePath, PathRelativizerService relativizer) throws IOException {
        super(storePath, PathStringDescriptor.INSTANCE, new SourcePathListExternalizer());
        this.myRelativizer = relativizer;
    }

    @Override
    public void update(String path, @Nullable List<SourcePathAndRootIndex> state) throws IOException {
        super.update(this.normalizePath(path), state != null ? this.normalizePaths(state) : null);
    }

    @Override
    public void appendData(String path, List<SourcePathAndRootIndex> data) throws IOException {
        super.appendData(this.normalizePath(path), data != null ? this.normalizePaths(data) : null);
    }

    public void appendData(String outputPath, int rootIndex, String sourcePath) throws IOException {
        super.appendData(this.normalizePath(outputPath), Collections.singletonList(new SourcePathAndRootIndex(this.normalizePath(sourcePath), rootIndex)));
    }

    @Override
    public void remove(String path) throws IOException {
        super.remove(this.normalizePath(path));
    }

    @Override
    @Nullable
    public List<SourcePathAndRootIndex> getState(String path) throws IOException {
        List list = (List)super.getState(this.normalizePath(path));
        return list != null ? ContainerUtil.map((Collection)list, it -> new SourcePathAndRootIndex(this.myRelativizer.toFull(it.myPath), it.myRootIndex)) : null;
    }

    private String normalizePath(@NotNull String path) {
        return this.myRelativizer.toRelative(path);
    }

    private List<SourcePathAndRootIndex> normalizePaths(@NotNull List<SourcePathAndRootIndex> state) {
        SmartList normalizePathList = new SmartList();
        state.forEach(arg_0 -> this.lambda$normalizePaths$1((List)normalizePathList, arg_0));
        return normalizePathList;
    }

    private /* synthetic */ void lambda$normalizePaths$1(List normalizePathList, SourcePathAndRootIndex it) {
        normalizePathList.add(new SourcePathAndRootIndex(this.normalizePath(it.myPath), it.myRootIndex));
    }

    private static class SourcePathListExternalizer
    implements DataExternalizer<List<SourcePathAndRootIndex>> {
        private SourcePathListExternalizer() {
        }

        public void save(@NotNull DataOutput out, List<SourcePathAndRootIndex> value) throws IOException {
            for (SourcePathAndRootIndex pair : value) {
                IOUtil.writeUTF((DataOutput)out, (String)pair.myPath);
                out.writeInt(pair.getRootIndex());
            }
        }

        public List<SourcePathAndRootIndex> read(@NotNull DataInput in) throws IOException {
            SmartList result = new SmartList();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                String path = IOUtil.readUTF((DataInput)stream);
                int index = stream.readInt();
                result.add(new SourcePathAndRootIndex(path, index));
            }
            return result;
        }
    }

    public static final class SourcePathAndRootIndex {
        private final String myPath;
        private final int myRootIndex;

        private SourcePathAndRootIndex(String path, int rootIndex) {
            this.myPath = path;
            this.myRootIndex = rootIndex;
        }

        public String getPath() {
            return this.myPath;
        }

        public int getRootIndex() {
            return this.myRootIndex;
        }
    }
}

