/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.google.gson.Gson;
import com.google.protobuf.Message;
import com.intellij.compiler.notNullVerification.NotNullVerifyingInstrumenter;
import com.intellij.openapi.application.ClassPathUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.tracing.Tracer;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.util.SystemProperties;
import com.jgoodies.forms.layout.CellConstraints;
import com.thoughtworks.qdox.JavaProjectBuilder;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.NetUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.jps.builders.impl.java.EclipseCompilerTool;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.builders.java.JavaSourceTransformer;
import org.jetbrains.jps.cmdline.BuildMain;
import org.jetbrains.jps.javac.ExternalJavacProcess;
import org.jetbrains.jps.javac.ast.JavacReferenceCollector;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.impl.JpsModelImpl;
import org.jetbrains.jps.model.serialization.JpsProjectLoader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public final class ClasspathBootstrap {
    private static final Logger LOG = Logger.getInstance(ClasspathBootstrap.class);
    private static final Class<?>[] COMMON_REQUIRED_CLASSES = new Class[]{NetUtil.class, EventLoopGroup.class, AddressResolverGroup.class, ByteBufAllocator.class, ProtobufDecoder.class};
    private static final String[] REFLECTION_OPEN_PACKAGES = new String[]{"jdk.compiler/com.sun.tools.javac.api=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.util=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.code=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.comp=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.file=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.main=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.model=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.parser=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.processing=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.tree=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.jvm=ALL-UNNAMED"};
    private static final String DEFAULT_MAVEN_REPOSITORY_PATH = ".m2/repository";
    private static final String PROTOBUF_JAVA6_VERSION = "3.5.1";
    private static final String PROTOBUF_JAVA6_JAR_NAME = "protobuf-java-3.5.1.jar";
    private static final String PROTOBUF_JAVA6_DISTRIBUTION_JAR_NAME = "protobuf-java6.jar";
    private static final String EXTERNAL_JAVAC_MODULE_NAME = "intellij.platform.jps.build.javac.rt.rpc";
    private static final String EXTERNAL_JAVAC_JAR_NAME = "jps-javac-rt-rpc.jar";

    private ClasspathBootstrap() {
    }

    private static void addToClassPath(Class<?> aClass, Set<String> result) {
        Path path = PathManager.getJarForClass(aClass);
        if (path == null) {
            return;
        }
        String pathString = path.toString();
        if (result.add(pathString) && pathString.endsWith("app.jar") && path.getFileName().toString().equals("app.jar") && path.getParent().equals(Paths.get(PathManager.getLibPath(), new String[0]))) {
            LOG.error("Due to " + aClass.getName() + " requirement, inappropriate " + pathString + " is added to build process classpath");
        }
    }

    private static void addToClassPath(Set<String> cp, @NotNull @NotNull Class<?> @NotNull [] classes) {
        for (Class<?> aClass : classes) {
            ClasspathBootstrap.addToClassPath(aClass, cp);
        }
    }

    @NotNull
    public static Collection<String> getBuildProcessApplicationClasspath() {
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        ClasspathBootstrap.addToClassPath(BuildMain.class, cp);
        ClasspathBootstrap.addToClassPath(ExternalJavacProcess.class, cp);
        ClasspathBootstrap.addToClassPath(JavacReferenceCollector.class, cp);
        ClasspathBootstrap.addToClassPath(cp, ClassPathUtil.getUtilClasses());
        ClassPathUtil.addKotlinStdlib(cp);
        ClasspathBootstrap.addToClassPath(cp, COMMON_REQUIRED_CLASSES);
        ClasspathBootstrap.addToClassPath(Message.class, cp);
        ClasspathBootstrap.addToClassPath(ClassWriter.class, cp);
        ClasspathBootstrap.addToClassPath(ClassVisitor.class, cp);
        ClasspathBootstrap.addToClassPath(JpsModel.class, cp);
        ClasspathBootstrap.addToClassPath(JpsModelImpl.class, cp);
        ClasspathBootstrap.addToClassPath(JpsProjectLoader.class, cp);
        ClasspathBootstrap.addToClassPath(AlienFormFileException.class, cp);
        ClasspathBootstrap.addToClassPath(GridConstraints.class, cp);
        ClasspathBootstrap.addToClassPath(CellConstraints.class, cp);
        cp.addAll(ClasspathBootstrap.getInstrumentationUtilRoots());
        ClasspathBootstrap.addToClassPath(IXMLBuilder.class, cp);
        ClasspathBootstrap.addToClassPath(JavaProjectBuilder.class, cp);
        ClasspathBootstrap.addToClassPath(Gson.class, cp);
        ClasspathBootstrap.addToClassPath(cp, ArtifactRepositoryManager.getClassesFromDependencies());
        ClasspathBootstrap.addToClassPath(Tracer.class, cp);
        try {
            Class<?> cmdLineWrapper = Class.forName("com.intellij.rt.execution.CommandLineWrapper");
            ClasspathBootstrap.addToClassPath(cmdLineWrapper, cp);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return cp;
    }

    public static void appendJavaCompilerClasspath(Collection<? super String> cp, boolean includeEcj) {
        File file;
        if (includeEcj && (file = EclipseCompilerTool.findEcjJarFile()) != null) {
            cp.add(file.getAbsolutePath());
        }
    }

    public static List<File> getExternalJavacProcessClasspath(String sdkHome, JavaCompilingTool compilingTool) {
        LinkedHashSet<File> cp = new LinkedHashSet<File>();
        cp.add(ClasspathBootstrap.getResourceFile(ExternalJavacProcess.class));
        cp.add(ClasspathBootstrap.getResourceFile(JavacReferenceCollector.class));
        cp.add(ClasspathBootstrap.getResourceFile(SystemInfoRt.class));
        try {
            cp.add(ClasspathBootstrap.getResourceFile(ClasspathBootstrap.class.getClassLoader().loadClass("gnu.trove.THashSet")));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (Class<?> aClass : COMMON_REQUIRED_CLASSES) {
            cp.add(ClasspathBootstrap.getResourceFile(aClass));
        }
        ClasspathBootstrap.addExternalJavacRpcClasspath(cp);
        try {
            Class<?> cmdLineWrapper = Class.forName("com.intellij.rt.execution.CommandLineWrapper");
            cp.add(ClasspathBootstrap.getResourceFile(cmdLineWrapper));
        }
        catch (Throwable th) {
            LOG.info(th);
        }
        try {
            String localJavaHome = FileUtilRt.toSystemIndependentName((String)SystemProperties.getJavaHome());
            File candidate = new File(sdkHome, "lib/tools.jar");
            if (candidate.exists()) {
                cp.add(candidate);
            } else {
                String localJarPath;
                String relPath;
                JavaCompiler systemCompiler = ToolProvider.getSystemJavaCompiler();
                Class<?> compilerClass = systemCompiler != null ? systemCompiler.getClass() : Class.forName("com.sun.tools.javac.api.JavacTool", false, ClasspathBootstrap.class.getClassLoader());
                File resourceFile = ClasspathBootstrap.getResourceFile(compilerClass);
                if (resourceFile != null && (relPath = FileUtilRt.getRelativePath((String)localJavaHome, (String)(localJarPath = FileUtilRt.toSystemIndependentName((String)resourceFile.getPath())), (char)'/')) != null) {
                    if (relPath.contains("..")) {
                        relPath = FileUtilRt.getRelativePath((String)FileUtilRt.toSystemIndependentName((String)new File(localJavaHome).getParent()), (String)localJarPath, (char)'/');
                    }
                    if (relPath != null) {
                        File targetFile = new File(sdkHome, relPath);
                        cp.add(targetFile);
                    }
                }
            }
        }
        catch (Throwable th) {
            LOG.info(th);
        }
        cp.addAll(compilingTool.getAdditionalClasspath());
        for (JavaSourceTransformer t : JavaSourceTransformer.getTransformers()) {
            cp.add(ClasspathBootstrap.getResourceFile(t.getClass()));
        }
        return new ArrayList<File>(cp);
    }

    private static void addExternalJavacRpcClasspath(@NotNull Collection<File> cp) {
        Path rootPath = Paths.get(ClasspathBootstrap.getResourcePath(ExternalJavacProcess.class), new String[0]);
        if (Files.isRegularFile(rootPath, new LinkOption[0])) {
            Path rtDirPath = rootPath.resolveSibling("rt");
            cp.add(rtDirPath.resolve(EXTERNAL_JAVAC_JAR_NAME).toFile());
            cp.add(rtDirPath.resolve(PROTOBUF_JAVA6_DISTRIBUTION_JAR_NAME).toFile());
        } else {
            cp.add(rootPath.resolveSibling(EXTERNAL_JAVAC_MODULE_NAME).toFile());
            File localRepositoryDir = ClasspathBootstrap.getMavenLocalRepositoryDir();
            File protobufJava6File = new File(String.join((CharSequence)File.separator, localRepositoryDir.getAbsolutePath(), "com", "google", "protobuf", "protobuf-java", PROTOBUF_JAVA6_VERSION, PROTOBUF_JAVA6_JAR_NAME));
            cp.add(protobufJava6File);
        }
    }

    @NotNull
    private static File getMavenLocalRepositoryDir() {
        String userHome = System.getProperty("user.home", null);
        return userHome != null ? new File(userHome, DEFAULT_MAVEN_REPOSITORY_PATH) : new File(DEFAULT_MAVEN_REPOSITORY_PATH);
    }

    @Nullable
    public static String getResourcePath(Class<?> aClass) {
        return PathManager.getResourceRoot(aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class"));
    }

    @Nullable
    public static File getResourceFile(Class<?> aClass) {
        String resourcePath = ClasspathBootstrap.getResourcePath(aClass);
        return resourcePath != null ? new File(resourcePath) : null;
    }

    public static void configureReflectionOpenPackages(Consumer<? super String> paramConsumer) {
        for (String aPackage : REFLECTION_OPEN_PACKAGES) {
            paramConsumer.accept("--add-opens");
            paramConsumer.accept(aPackage);
        }
    }

    private static List<String> getInstrumentationUtilRoots() {
        String instrumentationUtilPath = ClasspathBootstrap.getResourcePath(NotNullVerifyingInstrumenter.class);
        File instrumentationUtil = new File(instrumentationUtilPath);
        if (instrumentationUtil.isDirectory()) {
            return Arrays.asList(instrumentationUtilPath, new File(instrumentationUtil.getParentFile(), "intellij.java.compiler.instrumentationUtil.java8").getAbsolutePath());
        }
        return Collections.singletonList(instrumentationUtilPath);
    }
}

