/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.model;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.text.UniqueNameGenerator;
import org.jetbrains.annotations.NotNull;

public class DownloadableFileUrl {
    private final String myFileName;
    private final String myFileExtension;
    private final String myDownloadUrl;

    public DownloadableFileUrl(@NotNull String downloadUrl, @NotNull String fileName) {
        String fileExtension = FileUtilRt.getExtension((String)fileName);
        this.myFileName = FileUtilRt.getNameWithoutExtension((String)fileName);
        this.myFileExtension = fileExtension.length() > 0 && !fileExtension.startsWith(".") ? "." + fileExtension : fileExtension;
        this.myDownloadUrl = downloadUrl;
    }

    @NotNull
    public String getDownloadUrl() {
        return this.myDownloadUrl;
    }

    @NotNull
    public String getPresentableFileName() {
        return this.myFileName + this.myFileExtension;
    }

    @NotNull
    public String getPresentableDownloadUrl() {
        return this.myDownloadUrl;
    }

    @NotNull
    public String getDefaultFileName() {
        return this.generateFileName((Condition<? super String>)Conditions.alwaysTrue());
    }

    @NotNull
    public String generateFileName(@NotNull Condition<? super String> validator) {
        return UniqueNameGenerator.generateUniqueName((String)"", (String)this.myFileName, (String)this.myFileExtension, (String)"_", (String)"", validator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadableFileUrl that = (DownloadableFileUrl)o;
        return this.myDownloadUrl.equals(that.myDownloadUrl);
    }

    public int hashCode() {
        return this.myDownloadUrl.hashCode();
    }
}

