/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.loader;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.cache.client.JpsNettyClient;
import org.jetbrains.jps.cache.client.JpsServerClient;
import org.jetbrains.jps.cache.model.BuildTargetState;
import org.jetbrains.jps.incremental.Utils;

public class JpsMetadataLoader {
    private static final Logger LOG = Logger.getInstance(JpsMetadataLoader.class);
    private static final String SOURCES_STATE_FILE_NAME = "target_sources_state.json";
    private final File mySourceStateFile;
    private final JpsServerClient myClient;
    private final Type myTokenType;
    private final Gson myGson;

    public JpsMetadataLoader(@NotNull String projectPath, @NotNull JpsServerClient client) {
        this.myClient = client;
        this.myGson = new Gson();
        this.mySourceStateFile = new File(Utils.getDataStorageRoot(projectPath), SOURCES_STATE_FILE_NAME);
        this.myTokenType = new TypeToken<Map<String, Map<String, BuildTargetState>>>(){}.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Map<String, Map<String, BuildTargetState>> loadMetadataForCommit(@NotNull JpsNettyClient nettyClient, @NotNull String metadataId) {
        block12: {
            File tmpFolder = new File(PathManager.getTempPath());
            File metadataFile = this.myClient.downloadMetadataById(nettyClient, metadataId, tmpFolder);
            if (metadataFile == null) {
                return null;
            }
            try {
                Map map;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(metadataFile));
                try {
                    map = (Map)this.myGson.fromJson((Reader)bufferedReader, this.myTokenType);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.warn("Couldn't parse content of file " + metadataFile.getName(), (Throwable)e);
                        break block12;
                    }
                }
                bufferedReader.close();
                return map;
            }
            finally {
                if (metadataFile.exists()) {
                    FileUtil.delete((File)metadataFile);
                }
            }
        }
        return null;
    }

    @Nullable
    Map<String, Map<String, BuildTargetState>> loadCurrentProjectMetadata() {
        Map map;
        if (!this.mySourceStateFile.exists()) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.mySourceStateFile));
        try {
            map = (Map)this.myGson.fromJson((Reader)bufferedReader, this.myTokenType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.warn("Couldn't parse current project metadata " + this.mySourceStateFile.getName(), (Throwable)e);
                return null;
            }
        }
        bufferedReader.close();
        return map;
    }

    void dropCurrentProjectMetadata() {
        if (this.mySourceStateFile.exists()) {
            FileUtil.delete((File)this.mySourceStateFile);
        }
    }
}

