/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.client;

import io.netty.channel.Channel;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineProtoUtil;

public class JpsNettyClient {
    private final UUID mySessionId;
    private final Channel myChannel;
    private final AtomicInteger currentDownloadsCount;

    public JpsNettyClient(@NotNull Channel channel, @NotNull UUID sessionId) {
        this.myChannel = channel;
        this.mySessionId = sessionId;
        this.currentDownloadsCount = new AtomicInteger();
    }

    public void sendDescriptionStatusMessage(@NotNull String message) {
        this.myChannel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createCacheDownloadMessage(message)));
    }

    public void sendDescriptionStatusMessage(@NotNull String message, int expectedDownloads) {
        int currentDownloads = this.currentDownloadsCount.incrementAndGet();
        if (expectedDownloads == 0) {
            this.myChannel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createCacheDownloadMessage(message)));
        } else {
            int doubleExpectedDownloads = expectedDownloads * 2 + 1000;
            this.myChannel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createCacheDownloadMessageWithProgress(message, (float)currentDownloads / (float)doubleExpectedDownloads)));
        }
    }

    public void sendDownloadStatisticMessage(@NotNull String latestDownloadCommit, long decompressionTimeBytesPesSec, long deletionTimeBytesPerSec) {
        this.myChannel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createSaveDownloadStatisticMessage(latestDownloadCommit, decompressionTimeBytesPesSec, deletionTimeBytesPerSec)));
    }

    public static void saveLatestBuiltCommit(@NotNull Channel channel, @NotNull UUID sessionId) {
        channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(sessionId, CmdlineProtoUtil.createSaveLatestBuiltCommitMessage()));
    }
}

