/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.ClassRepr;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Difference;
import org.jetbrains.jps.builders.java.dependencyView.FieldRepr;
import org.jetbrains.jps.builders.java.dependencyView.MethodRepr;
import org.jetbrains.jps.builders.java.dependencyView.NamingContext;
import org.jetbrains.jps.builders.java.dependencyView.ParamAnnotation;
import org.jetbrains.jps.builders.java.dependencyView.ProtoFieldEntity;
import org.jetbrains.jps.builders.java.dependencyView.ProtoMethodEntity;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;

public abstract class AnnotationsChangeTracker {
    public static final Set<Recompile> RECOMPILE_ALL = Collections.unmodifiableSet(EnumSet.allOf(Recompile.class));
    public static final Set<Recompile> RECOMPILE_NONE = Collections.unmodifiableSet(EnumSet.noneOf(Recompile.class));

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public Set<Recompile> methodAnnotationsChanged(DependencyContext context, MethodRepr method, Difference.Specifier<TypeRepr.ClassType, Difference> annotationsDiff, Difference.Specifier<ParamAnnotation, Difference> paramAnnotationsDiff) {
        return RECOMPILE_NONE;
    }

    @NotNull
    @ApiStatus.Internal
    public Set<Recompile> methodAnnotationsChanged(NamingContext context, ProtoMethodEntity method, Difference.Specifier<TypeRepr.ClassType, Difference> annotationsDiff, Difference.Specifier<ParamAnnotation, Difference> paramAnnotationsDiff) {
        Set<Recompile> result;
        if (method instanceof MethodRepr && context instanceof DependencyContext && !(result = this.methodAnnotationsChanged((DependencyContext)context, (MethodRepr)method, annotationsDiff, paramAnnotationsDiff)).isEmpty()) {
            return result;
        }
        return RECOMPILE_NONE;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public Set<Recompile> fieldAnnotationsChanged(NamingContext context, FieldRepr field, Difference.Specifier<TypeRepr.ClassType, Difference> annotationsDiff) {
        return RECOMPILE_NONE;
    }

    @NotNull
    @ApiStatus.Internal
    public Set<Recompile> fieldAnnotationsChanged(NamingContext context, ProtoFieldEntity field, Difference.Specifier<TypeRepr.ClassType, Difference> annotationsDiff) {
        Set<Recompile> result;
        if (field instanceof FieldRepr && !(result = this.fieldAnnotationsChanged(context, (FieldRepr)field, annotationsDiff)).isEmpty()) {
            return result;
        }
        return RECOMPILE_NONE;
    }

    @NotNull
    public Set<Recompile> classAnnotationsChanged(NamingContext context, ClassRepr aClass, Difference.Specifier<TypeRepr.ClassType, Difference> annotationsDiff) {
        return RECOMPILE_NONE;
    }

    public static enum Recompile {
        USAGES,
        SUBCLASSES;

    }
}

