/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;

public class JavaSourceRootDescriptor
extends BuildRootDescriptor {
    private final FileFilter myFilterForExcludedPatterns;
    @NotNull
    public final File root;
    @NotNull
    public final ModuleBuildTarget target;
    public final boolean isGeneratedSources;
    public final boolean isTemp;
    private final String myPackagePrefix;
    private final Set<File> myExcludes;

    @Deprecated
    public JavaSourceRootDescriptor(@NotNull File root, @NotNull ModuleBuildTarget target, boolean isGenerated, boolean isTemp, @NotNull String packagePrefix, @NotNull Set<File> excludes) {
        this(root, target, isGenerated, isTemp, packagePrefix, excludes, FileFilters.EVERYTHING);
    }

    public JavaSourceRootDescriptor(@NotNull File root, @NotNull ModuleBuildTarget target, boolean isGenerated, boolean isTemp, @NotNull String packagePrefix, @NotNull Set<File> excludes, @NotNull FileFilter filterForExcludedPatterns) {
        this.root = root;
        this.target = target;
        this.isGeneratedSources = isGenerated;
        this.isTemp = isTemp;
        this.myPackagePrefix = packagePrefix;
        this.myExcludes = excludes;
        this.myFilterForExcludedPatterns = filterForExcludedPatterns;
    }

    public String toString() {
        return "RootDescriptor{target='" + this.target + "', root=" + this.root + ", generated=" + this.isGeneratedSources + "}";
    }

    @Override
    @NotNull
    public Set<File> getExcludedRoots() {
        return this.myExcludes;
    }

    @NotNull
    public String getPackagePrefix() {
        return this.myPackagePrefix;
    }

    @Override
    public String getRootId() {
        return FileUtil.toSystemIndependentName((String)this.root.getPath());
    }

    @Override
    public File getRootFile() {
        return this.root;
    }

    public ModuleBuildTarget getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public FileFilter createFileFilter() {
        JpsCompilerExcludes excludes = JpsJavaExtensionService.getInstance().getCompilerConfiguration(this.target.getModule().getProject()).getCompilerExcludes();
        FileFilter baseFilter = BuilderRegistry.getInstance().getModuleBuilderFileFilter();
        return file -> baseFilter.accept(file) && !excludes.isExcluded(file) && this.myFilterForExcludedPatterns.accept(file);
    }

    @Override
    public boolean isGenerated() {
        return this.isGeneratedSources;
    }

    @Override
    public boolean canUseFileCache() {
        return true;
    }
}

