/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public final class JavaModuleBuildTargetType
extends ModuleBasedBuildTargetType<ModuleBuildTarget> {
    public static final JavaModuleBuildTargetType PRODUCTION = new JavaModuleBuildTargetType("java-production", false);
    public static final JavaModuleBuildTargetType TEST = new JavaModuleBuildTargetType("java-test", true);
    public static final List<JavaModuleBuildTargetType> ALL_TYPES = ContainerUtil.immutableList((Object[])new JavaModuleBuildTargetType[]{PRODUCTION, TEST});
    private final boolean myTests;

    private JavaModuleBuildTargetType(String typeId, boolean tests) {
        super(typeId, true);
        this.myTests = tests;
    }

    @Override
    @NotNull
    public List<ModuleBuildTarget> computeAllTargets(@NotNull JpsModel model) {
        List modules = model.getProject().getModules();
        ArrayList<ModuleBuildTarget> targets = new ArrayList<ModuleBuildTarget>(modules.size());
        for (JpsModule module : modules) {
            targets.add(new ModuleBuildTarget(module, this));
        }
        return targets;
    }

    @NotNull
    public Loader createLoader(@NotNull JpsModel model) {
        return new Loader(model);
    }

    public boolean isTests() {
        return this.myTests;
    }

    public static JavaModuleBuildTargetType getInstance(boolean tests) {
        return tests ? TEST : PRODUCTION;
    }

    private class Loader
    extends BuildTargetLoader<ModuleBuildTarget> {
        private final Map<String, JpsModule> myModules = new HashMap<String, JpsModule>();

        Loader(JpsModel model) {
            for (JpsModule module : model.getProject().getModules()) {
                this.myModules.put(module.getName(), module);
            }
        }

        @Override
        @Nullable
        public ModuleBuildTarget createTarget(@NotNull String targetId) {
            JpsModule module = this.myModules.get(targetId);
            return module != null ? new ModuleBuildTarget(module, JavaModuleBuildTargetType.this) : null;
        }
    }
}

