/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl.storage;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.CompositeStorageOwner;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public class BuildTargetStorages
extends CompositeStorageOwner {
    private static final Logger LOG = Logger.getInstance(BuildTargetStorages.class);
    private final BuildTarget<?> myTarget;
    private final BuildDataPaths myPaths;
    private final ConcurrentMap<StorageProvider<? extends StorageOwner>, StorageOwner> myStorages = new ConcurrentHashMap<StorageProvider<? extends StorageOwner>, StorageOwner>(16, 0.75f, BuildDataManager.getConcurrencyLevel());

    public BuildTargetStorages(BuildTarget<?> target, BuildDataPaths paths) {
        this.myTarget = target;
        this.myPaths = paths;
    }

    @NotNull
    public <S extends StorageOwner> S getOrCreateStorage(@NotNull StorageProvider<S> provider, PathRelativizerService relativizer) throws IOException {
        try {
            return (S)this.myStorages.computeIfAbsent(provider, _provider -> {
                try {
                    return _provider.createStorage(this.myPaths.getTargetDataRoot(this.myTarget), relativizer);
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
            });
        }
        catch (BuildDataCorruptedException e) {
            LOG.info((Throwable)e);
            throw e.getCause();
        }
    }

    public void close(@NotNull StorageProvider<? extends StorageOwner> provider) throws IOException {
        StorageOwner storage = (StorageOwner)this.myStorages.remove(provider);
        if (storage != null) {
            storage.close();
        }
    }

    protected Iterable<StorageOwner> getChildStorages() {
        return () -> this.myStorages.values().iterator();
    }
}

