/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public final class BuildTargetRegistryImpl
implements BuildTargetRegistry {
    private final List<BuildTarget<?>> myAllTargets;
    private final Map<BuildTargetType<?>, List<? extends BuildTarget<?>>> myTargets = new HashMap();
    private final Map<JpsModule, List<ModuleBasedTarget>> myModuleBasedTargets = new HashMap<JpsModule, List<ModuleBasedTarget>>();

    public BuildTargetRegistryImpl(JpsModel model) {
        ArrayList targetsByType = new ArrayList();
        for (BuildTargetType<?> type : TargetTypeRegistry.getInstance().getTargetTypes()) {
            List<?> targets = type.computeAllTargets(model);
            this.myTargets.put(type, targets);
            targetsByType.add(targets);
            for (BuildTarget target : targets) {
                if (!(target instanceof ModuleBasedTarget)) continue;
                ModuleBasedTarget t = (ModuleBasedTarget)target;
                JpsModule module = t.getModule();
                List<ModuleBasedTarget> list = this.myModuleBasedTargets.get(module);
                if (list == null) {
                    list = new ArrayList<ModuleBasedTarget>();
                    this.myModuleBasedTargets.put(module, list);
                }
                list.add(t);
            }
        }
        this.myAllTargets = Collections.unmodifiableList(ContainerUtil.concat(targetsByType));
    }

    @Override
    @NotNull
    public Collection<ModuleBasedTarget<?>> getModuleBasedTargets(@NotNull JpsModule module, @NotNull BuildTargetRegistry.ModuleTargetSelector selector) {
        List<ModuleBasedTarget> targets = this.myModuleBasedTargets.get(module);
        if (targets == null || targets.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        for (ModuleBasedTarget target : targets) {
            switch (selector) {
                case ALL: {
                    result.add(target);
                    break;
                }
                case PRODUCTION: {
                    if (target.isTests()) break;
                    result.add(target);
                    break;
                }
                case TEST: {
                    if (!target.isTests()) break;
                    result.add(target);
                }
            }
        }
        return result;
    }

    @Override
    @NotNull
    public <T extends BuildTarget<?>> List<T> getAllTargets(@NotNull BuildTargetType<T> type) {
        return this.myTargets.get(type);
    }

    @Override
    @NotNull
    public List<BuildTarget<?>> getAllTargets() {
        return this.myAllTargets;
    }
}

