/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;

public final class BuildTargetChunk {
    private final Set<? extends BuildTarget<?>> myTargets;

    public BuildTargetChunk(Set<? extends BuildTarget<?>> targets) {
        this.myTargets = targets;
    }

    public Set<? extends BuildTarget<?>> getTargets() {
        return this.myTargets;
    }

    public String toString() {
        return this.myTargets.toString();
    }

    public String getPresentableName() {
        String name = this.myTargets.iterator().next().getPresentableName();
        int size = this.myTargets.size();
        return size > 1 ? name + " and " + (size - 1) + " more" : name;
    }

    public static BuildTargetChunk forSingleTarget(@NotNull BuildTarget<?> target) {
        return new BuildTargetChunk(Collections.singleton(target));
    }

    public static BuildTargetChunk forModulesChunk(@NotNull ModuleChunk chunk) {
        return new BuildTargetChunk(chunk.getTargets());
    }
}

