/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.JavaBackwardReferenceIndexWriter;
import org.jetbrains.jps.backwardRefs.SignatureData;
import org.jetbrains.jps.backwardRefs.index.CompiledFileData;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacRef;
import org.jetbrains.jps.javac.ast.api.JavacTypeCast;

public final class BackwardReferenceIndexUtil {
    private static final Logger LOG = Logger.getInstance(BackwardReferenceIndexUtil.class);

    static void registerFile(String filePath, Iterable<Object2IntMap.Entry<? extends JavacRef>> refs, Collection<? extends JavacDef> defs, Collection<? extends JavacTypeCast> casts, Collection<? extends JavacRef> implicitToString, JavaBackwardReferenceIndexWriter writer) {
        try {
            int fileId = writer.enumeratePath(filePath);
            int funExprId = 0;
            HashMap<CompilerRef, Void> definitions = new HashMap<CompilerRef, Void>(defs.size());
            HashMap<CompilerRef, Collection<CompilerRef>> backwardHierarchyMap = new HashMap<CompilerRef, Collection<CompilerRef>>();
            HashMap<SignatureData, Collection<CompilerRef>> signatureData = new HashMap<SignatureData, Collection<CompilerRef>>();
            HashMap<CompilerRef, Collection<CompilerRef>> castMap = new HashMap<CompilerRef, Collection<CompilerRef>>();
            HashMap<CompilerRef, Void> implicitToStringMap = new HashMap<CompilerRef, Void>();
            AnonymousClassEnumerator anonymousClassEnumerator = new AnonymousClassEnumerator();
            for (JavacDef javacDef : defs) {
                if (javacDef instanceof JavacDef.JavacClassDef) {
                    JavacRef[] superClasses;
                    CompilerRef.CompilerClassHierarchyElementDef aClass;
                    JavacRef.JavacClass javacClass = (JavacRef.JavacClass)javacDef.getDefinedElement();
                    if (javacClass.isPackageInfo()) continue;
                    if (javacClass.isAnonymous()) {
                        JavacRef[] classes = ((JavacDef.JavacClassDef)javacDef).getSuperClasses();
                        if (classes.length == 0) {
                            LOG.info("Seems that compilation will finish with errors in anonymous class inside file " + filePath);
                            continue;
                        }
                        aClass = anonymousClassEnumerator.addAnonymous(javacClass.getName(), writer.asClassUsage(classes[0]));
                    } else {
                        aClass = writer.asClassUsage((JavacRef)javacClass);
                    }
                    definitions.put(aClass, null);
                    for (JavacRef superClass : superClasses = ((JavacDef.JavacClassDef)javacDef).getSuperClasses()) {
                        CompilerRef.JavaCompilerClassRef superClassRef = writer.asClassUsage(superClass);
                        backwardHierarchyMap.computeIfAbsent(superClassRef, k -> new SmartList()).add(aClass);
                    }
                    continue;
                }
                if (javacDef instanceof JavacDef.JavacFunExprDef) {
                    CompilerRef.JavaCompilerClassRef javaCompilerClassRef = writer.asClassUsage(javacDef.getDefinedElement());
                    int id = funExprId++;
                    CompilerRef.JavaCompilerFunExprDef result = new CompilerRef.JavaCompilerFunExprDef(id);
                    definitions.put(result, null);
                    backwardHierarchyMap.computeIfAbsent(javaCompilerClassRef, __ -> new SmartList()).add(result);
                    continue;
                }
                if (!(javacDef instanceof JavacDef.JavacMemberDef)) continue;
                CompilerRef compilerRef = writer.enumerateNames(javacDef.getDefinedElement(), (Function<? super String, Integer>)((Function)name -> anonymousClassEnumerator.getCompilerRefIfAnonymous((String)name)));
                CompilerRef.JavaCompilerClassRef returnType = writer.asClassUsage(((JavacDef.JavacMemberDef)javacDef).getReturnType());
                if (compilerRef == null) continue;
                SignatureData data = new SignatureData(returnType.getName(), ((JavacDef.JavacMemberDef)javacDef).getIteratorKind(), ((JavacDef.JavacMemberDef)javacDef).isStatic());
                signatureData.computeIfAbsent(data, element -> new SmartList()).add(compilerRef);
            }
            HashMap<CompilerRef, Integer> convertedRefs = new HashMap<CompilerRef, Integer>();
            for (Object2IntMap.Entry<? extends JavacRef> entry : refs) {
                JavacRef ref = (JavacRef)entry.getKey();
                int count = entry.getIntValue();
                CompilerRef compilerRef = writer.enumerateNames(ref, (Function<? super String, Integer>)((Function)name -> anonymousClassEnumerator.getCompilerRefIfAnonymous((String)name)));
                if (compilerRef == null) continue;
                convertedRefs.merge(compilerRef, count, (oldValue, value) -> oldValue + value);
            }
            for (JavacTypeCast javacTypeCast : casts) {
                CompilerRef enumeratedOperandType;
                CompilerRef enumeratedCastType = writer.enumerateNames((JavacRef)javacTypeCast.getCastType(), (Function<? super String, Integer>)((Function)name -> null));
                if (enumeratedCastType == null || (enumeratedOperandType = writer.enumerateNames((JavacRef)javacTypeCast.getOperandType(), (Function<? super String, Integer>)((Function)name -> null))) == null) continue;
                castMap.computeIfAbsent(enumeratedCastType, t -> new SmartList()).add(enumeratedOperandType);
            }
            for (JavacRef javacRef : implicitToString) {
                implicitToStringMap.put(writer.asClassUsage(javacRef), null);
            }
            writer.writeData(fileId, new CompiledFileData(backwardHierarchyMap, castMap, convertedRefs, definitions, signatureData, implicitToStringMap));
        }
        catch (IOException e) {
            writer.setRebuildCause(e);
        }
    }

    private static final class AnonymousClassEnumerator {
        private Map<String, CompilerRef.CompilerClassHierarchyElementDef> myAnonymousName2Id = null;

        private AnonymousClassEnumerator() {
        }

        private CompilerRef.JavaCompilerAnonymousClassRef addAnonymous(String internalName, CompilerRef.JavaCompilerClassRef base) {
            if (this.myAnonymousName2Id == null) {
                this.myAnonymousName2Id = new HashMap<String, CompilerRef.CompilerClassHierarchyElementDef>();
            }
            int anonymousIdx = this.myAnonymousName2Id.size();
            this.myAnonymousName2Id.put(internalName, base);
            return new CompilerRef.JavaCompilerAnonymousClassRef(anonymousIdx);
        }

        private Integer getCompilerRefIfAnonymous(String className) {
            if (this.myAnonymousName2Id == null) {
                return null;
            }
            CompilerRef.CompilerClassHierarchyElementDef ref = this.myAnonymousName2Id.get(className);
            return ref == null ? null : Integer.valueOf(ref.getName());
        }
    }
}

