/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.messages;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ArrayUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001b\u0010\u000f\u001a\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00020\u00020\u0010\u00a2\u0006\u0002\b\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/editorconfig/language/messages/EditorConfigWrongFileEncodingNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "buildPanel", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createNotificationPanel", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getKey", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isSafeToConvertTo", "Lcom/intellij/openapi/vfs/encoding/EncodingUtil$Magic8;", "text", "", "isSafeToReloadIn", "update", "", "Companion", "intellij.editorconfig"})
public final class EditorConfigWrongFileEncodingNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @NotNull
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"editorconfig.wrong.encoding.notification");
    @Deprecated
    @NotNull
    private static final Key<Boolean> HIDDEN_KEY = Key.create((String)"editorconfig.wrong.encoding.notification.hidden");
    @Deprecated
    @NotNull
    private static final String DISABLE_KEY = "editorconfig.wrong.encoding.notification.disabled";

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        if (editor.getUserData(HIDDEN_KEY) != null) {
            return null;
        }
        if (PropertiesComponent.getInstance().isTrueValue(DISABLE_KEY)) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)file.getExtension(), (Object)"editorconfig")) {
            return null;
        }
        if (Intrinsics.areEqual((Object)file.getCharset(), (Object)Charsets.UTF_8)) {
            return null;
        }
        return this.buildPanel(project, editor, file);
    }

    private final EditorNotificationPanel buildPanel(Project project, Editor editor, VirtualFile file) {
        EditorNotificationPanel result2 = new EditorNotificationPanel(editor, null, null, EditorNotificationPanel.Status.Warning);
        result2.text(EditorConfigBundle.INSTANCE.get("notification.encoding.message"));
        String convert = EditorConfigBundle.INSTANCE.get("notification.action.convert");
        result2.createActionLabel(convert, () -> EditorConfigWrongFileEncodingNotificationProvider.buildPanel$lambda$0(editor, this, file, project));
        String hide = EditorConfigBundle.INSTANCE.get("notification.action.hide.once");
        result2.createActionLabel(hide, () -> EditorConfigWrongFileEncodingNotificationProvider.buildPanel$lambda$1(editor, this, file, project));
        String hideForever = EditorConfigBundle.INSTANCE.get("notification.action.hide.forever");
        result2.createActionLabel(hideForever, () -> EditorConfigWrongFileEncodingNotificationProvider.buildPanel$lambda$2(this, file, project));
        return result2;
    }

    private final void update(VirtualFile file, Project project) {
        EditorNotifications.getInstance((Project)project).updateNotifications(file);
    }

    private final EncodingUtil.Magic8 isSafeToReloadIn(VirtualFile file, CharSequence text) {
        byte[] byArray;
        byte[] bytes = file.contentsToByteArray();
        byte[] bom = file.getBOM();
        if (bom != null && !CharsetToolkit.canHaveBom((Charset)Charsets.UTF_8, (byte[])bom)) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        byte[] mandatoryBom = CharsetToolkit.getMandatoryBom((Charset)Charsets.UTF_8);
        if (mandatoryBom != null && !ArrayUtil.startsWith((byte[])bytes, (byte[])mandatoryBom)) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        String loaded = ((Object)LoadTextUtil.getTextByBinaryPresentation((byte[])bytes, (Charset)Charsets.UTF_8)).toString();
        try {
            String separator = FileDocumentManager.getInstance().getLineSeparator(file, null);
            byte[] byArray2 = StringUtil.convertLineSeparators((String)loaded, (String)separator).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            byArray = byArray2;
        }
        catch (UnsupportedOperationException e) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        catch (NullPointerException e) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        byte[] bytesToSave = byArray;
        if (bom != null && !ArrayUtil.startsWith((byte[])bytesToSave, (byte[])bom)) {
            bytesToSave = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytesToSave);
        }
        return !Arrays.equals(bytesToSave, bytes) ? EncodingUtil.Magic8.NO_WAY : (StringUtil.equals((CharSequence)loaded, (CharSequence)text) ? EncodingUtil.Magic8.ABSOLUTELY : EncodingUtil.Magic8.WELL_IF_YOU_INSIST);
    }

    private final EncodingUtil.Magic8 isSafeToConvertTo(VirtualFile file, CharSequence text) {
        EncodingUtil.Magic8 magic8;
        try {
            byte[] bytesOnDisk = file.contentsToByteArray();
            String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(file, null);
            CharSequence textToSave = Intrinsics.areEqual((Object)lineSeparator, (Object)"\n") ? text : StringUtilRt.convertLineSeparators((CharSequence)text, (String)lineSeparator);
            byte[] saved = (byte[])LoadTextUtil.chooseMostlyHarmlessCharset((Charset)file.getCharset(), (Charset)Charsets.UTF_8, (String)((Object)textToSave).toString()).second;
            CharSequence textLoadedBack = LoadTextUtil.getTextByBinaryPresentation((byte[])saved, (Charset)Charsets.UTF_8);
            magic8 = !StringUtil.equals((CharSequence)text, (CharSequence)textLoadedBack) ? EncodingUtil.Magic8.NO_WAY : (Arrays.equals(saved, bytesOnDisk) ? EncodingUtil.Magic8.ABSOLUTELY : EncodingUtil.Magic8.WELL_IF_YOU_INSIST);
        }
        catch (UnsupportedOperationException e) {
            magic8 = EncodingUtil.Magic8.NO_WAY;
        }
        return magic8;
    }

    private static final void buildPanel$lambda$0(Editor $editor, EditorConfigWrongFileEncodingNotificationProvider this$0, VirtualFile $file, Project $project) {
        String text = $editor.getDocument().getText();
        EncodingUtil.Magic8 isSafeToConvert = this$0.isSafeToConvertTo($file, text);
        EncodingUtil.Magic8 isSafeToReload = this$0.isSafeToReloadIn($file, text);
        ChangeFileEncodingAction.changeTo((Project)$project, (Document)$editor.getDocument(), (Editor)$editor, (VirtualFile)$file, (Charset)Charsets.UTF_8, (EncodingUtil.Magic8)isSafeToConvert, (EncodingUtil.Magic8)isSafeToReload);
    }

    private static final void buildPanel$lambda$1(Editor $editor, EditorConfigWrongFileEncodingNotificationProvider this$0, VirtualFile $file, Project $project) {
        $editor.putUserData(HIDDEN_KEY, (Object)true);
        this$0.update($file, $project);
    }

    private static final void buildPanel$lambda$2(EditorConfigWrongFileEncodingNotificationProvider this$0, VirtualFile $file, Project $project) {
        PropertiesComponent.getInstance().setValue(DISABLE_KEY, true);
        this$0.update($file, $project);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000b0\u000b0\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/editorconfig/language/messages/EditorConfigWrongFileEncodingNotificationProvider$Companion;", "", "()V", "DISABLE_KEY", "", "HIDDEN_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "KEY", "Lcom/intellij/ui/EditorNotificationPanel;", "intellij.editorconfig"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

