/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import kotlin.Metadata;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigOptionValueList;
import org.editorconfig.language.psi.interfaces.EditorConfigDescribableElement;
import org.editorconfig.language.services.EditorConfigElementFactory;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveListValueQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.editorconfig"})
public final class EditorConfigRemoveListValueQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.value.remove.description");
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        PsiElement psiElement = element.getParent();
        EditorConfigOptionValueList editorConfigOptionValueList = psiElement instanceof EditorConfigOptionValueList ? (EditorConfigOptionValueList)psiElement : null;
        if (editorConfigOptionValueList == null) {
            return;
        }
        EditorConfigOptionValueList list = editorConfigOptionValueList;
        IntRange globalRange = EditorConfigPsiTreeUtil.INSTANCE.findRemovableRange(element);
        int listOffset = list.getTextOffset();
        IntRange parentRange = new IntRange(globalRange.getStart() - listOffset, globalRange.getEndInclusive() - listOffset);
        CharSequence text = list.getText();
        CharSequence newText = StringsKt.removeRange((CharSequence)text, (IntRange)parentRange);
        EditorConfigElementFactory factory = EditorConfigElementFactory.Companion.getInstance(project);
        EditorConfigDescribableElement newList = factory.createAnyValue(newText);
        CodeStyleManager manager = CodeStyleManager.getInstance((Project)project);
        manager.performActionWithFormatterDisabled(() -> EditorConfigRemoveListValueQuickFix.applyFix$lambda$0(list, newList));
    }

    private static final void applyFix$lambda$0(EditorConfigOptionValueList $list, EditorConfigDescribableElement $newList) {
        $list.replace($newList);
    }
}

