/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.io.File;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigPattern;
import org.editorconfig.language.util.EditorConfigPresentationUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/editorconfig/core/EditorConfigAutomatonBuilder;", "", "()V", "KEY_EDITORCONFIG_ELEMENT_AUTOMATON", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Ldk/brics/automaton/Automaton;", "KEY_EDITORCONFIG_ELEMENT_RUN_AUTOMATON", "Ldk/brics/automaton/RunAutomaton;", "Log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getCachedHeaderAutomaton", "header", "Lorg/editorconfig/language/psi/EditorConfigHeader;", "getCachedHeaderRunAutomaton", "getCachedPatternAutomaton", "pattern", "Lorg/editorconfig/language/psi/EditorConfigPattern;", "sanitizeGlob", "", "text", "path", "intellij.editorconfig"})
public final class EditorConfigAutomatonBuilder {
    @NotNull
    public static final EditorConfigAutomatonBuilder INSTANCE = new EditorConfigAutomatonBuilder();
    @NotNull
    private static final Key<CachedValue<RunAutomaton>> KEY_EDITORCONFIG_ELEMENT_RUN_AUTOMATON = new Key("KEY_EDITORCONFIG_ELEMENT_RUN_AUTOMATON");
    @NotNull
    private static final Key<CachedValue<Automaton>> KEY_EDITORCONFIG_ELEMENT_AUTOMATON = new Key("KEY_EDITORCONFIG_ELEMENT_AUTOMATON");
    @NotNull
    private static final Logger Log;

    private EditorConfigAutomatonBuilder() {
    }

    @NotNull
    public final RunAutomaton getCachedHeaderRunAutomaton(@NotNull EditorConfigHeader header) {
        return (RunAutomaton)CachedValuesManager.getCachedValue((PsiElement)header, KEY_EDITORCONFIG_ELEMENT_RUN_AUTOMATON, () -> EditorConfigAutomatonBuilder.getCachedHeaderRunAutomaton$lambda$0(header));
    }

    @NotNull
    public final Automaton getCachedHeaderAutomaton(@NotNull EditorConfigHeader header) {
        return (Automaton)CachedValuesManager.getCachedValue((PsiElement)header, KEY_EDITORCONFIG_ELEMENT_AUTOMATON, () -> EditorConfigAutomatonBuilder.getCachedHeaderAutomaton$lambda$1(header));
    }

    @NotNull
    public final Automaton getCachedPatternAutomaton(@NotNull EditorConfigPattern pattern) {
        return (Automaton)CachedValuesManager.getCachedValue((PsiElement)pattern, KEY_EDITORCONFIG_ELEMENT_AUTOMATON, () -> EditorConfigAutomatonBuilder.getCachedPatternAutomaton$lambda$2(pattern));
    }

    @NotNull
    public final String sanitizeGlob(@NotNull String text, @NotNull String path) {
        Object source = StringsKt.replace$default((String)text, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        source = StringsKt.replace$default((String)source, (String)"\\\\#", (String)"#", (boolean)false, (int)4, null);
        int separator = StringsKt.indexOf$default((CharSequence)((CharSequence)(source = StringsKt.replace$default((String)source, (String)"\\\\;", (String)";", (boolean)false, (int)4, null))), (String)"/", (int)0, (boolean)false, (int)6, null);
        if (separator >= 0) {
            Object object;
            String string = StringsKt.replace$default((String)path, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
            if (separator == 0) {
                String string2 = ((String)source).substring(1);
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                object = source;
            }
            source = string + "/" + (String)object;
        } else {
            source = "**/" + (String)source;
        }
        source = EditorConfig.convertGlobToRegEx((String)source, new ArrayList<int[]>());
        return StringsKt.replace$default((String)source, (String)"(?:", (String)"(", (boolean)false, (int)4, null);
    }

    private static final CachedValueProvider.Result getCachedHeaderRunAutomaton$lambda$0(EditorConfigHeader $header) {
        RunAutomaton runAutomaton = new RunAutomaton(INSTANCE.getCachedHeaderAutomaton($header));
        Object[] objectArray = new Object[]{$header};
        return CachedValueProvider.Result.create((Object)runAutomaton, (Object[])objectArray);
    }

    private static final CachedValueProvider.Result getCachedHeaderAutomaton$lambda$1(EditorConfigHeader $header) {
        String text = $header.getText();
        Log.assertTrue($header.isValidGlob(), (Object)("builder was given invalid header: " + text));
        Log.assertTrue(text.length() >= 3, (Object)("builder was given a header of insufficient length: " + text));
        String string = text.substring(1, text.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String internalText = string;
        String path = EditorConfigPresentationUtil.path($header);
        Automaton automaton = new RegExp(INSTANCE.sanitizeGlob(internalText, path)).toAutomaton();
        Object[] objectArray = new Object[]{$header};
        return CachedValueProvider.Result.create((Object)automaton, (Object[])objectArray);
    }

    private static final CachedValueProvider.Result getCachedPatternAutomaton$lambda$2(EditorConfigPattern $pattern) {
        String text = $pattern.getText();
        EditorConfigHeader header = $pattern.getHeader();
        Log.assertTrue(header.isValidGlob(), (Object)("builder was given a pattern in invalid header: " + text + " in " + header.getText()));
        Log.assertTrue(header.getTextLength() >= 3, (Object)("builder was given a pattern in header of insufficient length: " + text + " in " + header.getText()));
        String path = EditorConfigPresentationUtil.path($pattern);
        String glob = INSTANCE.sanitizeGlob(text, path);
        Automaton automaton = new RegExp(glob).toAutomaton();
        Object[] objectArray = new Object[]{$pattern};
        return CachedValueProvider.Result.create((Object)automaton, (Object[])objectArray);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorConfigAutomatonBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        Log = logger;
    }
}

