/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.generate;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.LightEditActionFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.editorconfig.configmanagement.export.EditorConfigSettingsWriter;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigOption;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.editorconfig.language.psi.EditorConfigSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class EditorConfigGenerateLanguagePropertiesAction
extends CodeInsightAction {
    private static final CodeInsightActionHandler HANDLER = new LanguagePropertiesGenerator();
    private static final Logger LOG = Logger.getInstance(EditorConfigGenerateLanguagePropertiesAction.class);

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return HANDLER;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (file instanceof EditorConfigPsiFile) {
            PsiElement contextElement;
            int currOffset = editor.getCaretModel().getOffset();
            if (currOffset == file.getTextLength() && currOffset > 0) {
                --currOffset;
            }
            if ((contextElement = file.findElementAt(currOffset)) != null) {
                if (contextElement instanceof PsiWhiteSpace) {
                    PsiElement prev = contextElement.getPrevSibling();
                    return prev != null && (prev.getNode().getElementType() == EditorConfigElementTypes.SECTION || prev.getNode().getElementType() == EditorConfigElementTypes.HEADER || prev instanceof EditorConfigOption);
                }
                if (contextElement.getNode().getElementType() == EditorConfigElementTypes.IDENTIFIER) {
                    return contextElement.getTextRange().getStartOffset() == currOffset;
                }
            }
        }
        return false;
    }

    @TestOnly
    public static void generateProperties(@NotNull Project project, @NotNull Editor editor, @NotNull Language language) {
        LanguagePropertiesGenerator.generateProperties(project, editor, language);
    }

    private static class LanguagePropertiesGenerator
    implements CodeInsightActionHandler {
        private LanguagePropertiesGenerator() {
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            ListPopup languagePopup = LanguagePropertiesGenerator.createLanguagePopup(project, file, editor);
            languagePopup.showInBestPositionFor(editor);
        }

        private static void generateProperties(@NotNull Project project, @NotNull Editor editor, @NotNull Language language) {
            LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)language);
            if (provider != null) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                try (EditorConfigSettingsWriter writer = new EditorConfigSettingsWriter(project, output, CodeStyle.getSettings((Project)project), false, false).forLanguages(language).forPropertyKinds(EditorConfigPropertyKind.LANGUAGE).withoutHeaders();){
                    writer.writeSettings();
                    writer.flush();
                    String text = new String(output.toByteArray(), StandardCharsets.UTF_8);
                    CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> editor.getDocument().insertString(editor.getCaretModel().getOffset(), (CharSequence)text)));
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        private static ListPopup createLanguagePopup(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor) {
            DefaultActionGroup languageGroup = new DefaultActionGroup();
            Set<Language> preferredLanguages = LanguagePropertiesGenerator.getPreferredLanguages(file, editor.getCaretModel().getOffset());
            LanguagePropertiesGenerator.getSupportedLanguages().stream().sorted((l1, l2) -> {
                if (preferredLanguages == null) {
                    return 0;
                }
                return (preferredLanguages.contains(l2) ? 1 : 0) - (preferredLanguages.contains(l1) ? 1 : 0);
            }).forEach(language -> languageGroup.add((AnAction)LightEditActionFactory.create((String)language.getDisplayName(), event -> LanguagePropertiesGenerator.generateProperties(project, editor, language))));
            return JBPopupFactory.getInstance().createActionGroupPopup(EditorConfigBundle.message("popup.title.choose.language"), (ActionGroup)languageGroup, DataManager.getInstance().getDataContext((Component)editor.getComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        }

        private static List<Language> getSupportedLanguages() {
            return LanguageCodeStyleSettingsProvider.getAllProviders().stream().filter(provider -> provider.supportsExternalFormats()).map(provider -> provider.getLanguage()).sorted((l1, l2) -> l1.getDisplayName().compareToIgnoreCase(l2.getDisplayName())).collect(Collectors.toList());
        }

        @Nullable
        private static Set<Language> getPreferredLanguages(@NotNull PsiFile file, int offset) {
            EditorConfigHeader header;
            HashSet<Language> languages = new HashSet<Language>();
            int currOffset = offset == file.getTextLength() && offset > 0 ? offset - 1 : offset;
            PsiElement contextElement = file.findElementAt(currOffset);
            if (contextElement != null && (header = LanguagePropertiesGenerator.findHeader(contextElement)) != null) {
                String pattern = header.getText();
                if ("*".equals(pattern = StringUtil.trimEnd((String)StringUtil.trimStart((String)pattern, (String)"["), (String)"]").trim())) {
                    return null;
                }
                for (FileType fileType : FileTypeManager.getInstance().getRegisteredFileTypes()) {
                    String testName;
                    if (!(fileType instanceof LanguageFileType) || !EditorConfig.filenameMatches("", pattern, testName = "/a." + fileType.getDefaultExtension())) continue;
                    languages.add(((LanguageFileType)fileType).getLanguage());
                }
            }
            return languages;
        }

        @Nullable
        private static EditorConfigHeader findHeader(@NotNull PsiElement contextElement) {
            PsiElement prev;
            if (contextElement instanceof PsiWhiteSpace && (prev = contextElement.getPrevSibling()) instanceof EditorConfigSection) {
                return ((EditorConfigSection)prev).getHeader();
            }
            for (PsiElement parent = contextElement.getParent(); parent != null && !(parent instanceof PsiFile); parent = parent.getParent()) {
                if (!(parent instanceof EditorConfigSection)) continue;
                return ((EditorConfigSection)parent).getHeader();
            }
            return null;
        }
    }
}

