/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntellijPropertyKindMap {
    private static final Map<String, EditorConfigPropertyKind> PROPERTY_KIND_MAP = new HashMap<String, EditorConfigPropertyKind>();

    @NotNull
    public static EditorConfigPropertyKind getPropertyKind(@NotNull String name) {
        if (PROPERTY_KIND_MAP.containsKey(name)) {
            return PROPERTY_KIND_MAP.get(name);
        }
        return EditorConfigPropertyKind.LANGUAGE;
    }

    private static void collectCommonLanguageProperties() {
        AbstractCodeStylePropertyMapper mapper = new AbstractCodeStylePropertyMapper(CodeStyleSettings.getDefaults()){

            @NotNull
            protected List<AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor> getSupportedFields() {
                ArrayList<AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor> descriptors = new ArrayList<AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor>();
                descriptors.add(new AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor((Object)new CommonCodeStyleSettings(Language.ANY), null));
                descriptors.add(new AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor((Object)new CommonCodeStyleSettings.IndentOptions(), null));
                return descriptors;
            }

            @NotNull
            public String getLanguageDomainId() {
                return "any";
            }

            @Nullable
            public String getPropertyDescription(@NotNull String externalName) {
                return null;
            }
        };
        for (String property : mapper.enumProperties()) {
            PROPERTY_KIND_MAP.put(property, EditorConfigPropertyKind.COMMON);
        }
    }

    static {
        IntellijPropertyKindMap.collectCommonLanguageProperties();
        PROPERTY_KIND_MAP.put("max_line_length", EditorConfigPropertyKind.EDITOR_CONFIG_STANDARD);
        PROPERTY_KIND_MAP.put("indent_size", EditorConfigPropertyKind.EDITOR_CONFIG_STANDARD);
        PROPERTY_KIND_MAP.put("indent_style", EditorConfigPropertyKind.EDITOR_CONFIG_STANDARD);
        PROPERTY_KIND_MAP.put("insert_final_newline", EditorConfigPropertyKind.EDITOR_CONFIG_STANDARD);
        PROPERTY_KIND_MAP.put("end_of_line", EditorConfigPropertyKind.EDITOR_CONFIG_STANDARD);
        PROPERTY_KIND_MAP.put("trim_trailing_whitespace", EditorConfigPropertyKind.EDITOR_CONFIG_STANDARD);
        PROPERTY_KIND_MAP.put("tab_width", EditorConfigPropertyKind.EDITOR_CONFIG_STANDARD);
        PROPERTY_KIND_MAP.put("charset", EditorConfigPropertyKind.EDITOR_CONFIG_STANDARD);
        PROPERTY_KIND_MAP.put("formatter_off_tag", EditorConfigPropertyKind.GENERIC);
        PROPERTY_KIND_MAP.put("formatter_on_tag", EditorConfigPropertyKind.GENERIC);
        PROPERTY_KIND_MAP.put("formatter_tags_enabled", EditorConfigPropertyKind.GENERIC);
        PROPERTY_KIND_MAP.put("formatter_enabled", EditorConfigPropertyKind.GENERIC);
        PROPERTY_KIND_MAP.put("visual_guides", EditorConfigPropertyKind.GENERIC);
        PROPERTY_KIND_MAP.put("wrap_on_typing", EditorConfigPropertyKind.GENERIC);
        PROPERTY_KIND_MAP.put("smart_tabs", EditorConfigPropertyKind.GENERIC);
        PROPERTY_KIND_MAP.put("continuation_indent_size", EditorConfigPropertyKind.GENERIC);
    }
}

