/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStyleChoiceList;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertiesUtil;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.ExternalStringAccessor;
import com.intellij.application.options.codeStyle.properties.GeneralCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.IntegerAccessor;
import com.intellij.application.options.codeStyle.properties.ValueListPropertyAccessor;
import com.intellij.application.options.codeStyle.properties.VisualGuidesAccessor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.extended.EditorConfigIntellijNameUtil;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.editorconfig.configmanagement.extended.IntellijPropertyKindMap;
import org.editorconfig.language.extensions.EditorConfigOptionDescriptorProvider;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigConstantDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigListDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigNumberDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigOptionDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigStringDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigUnionDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijConfigOptionDescriptorProvider
implements EditorConfigOptionDescriptorProvider {
    private static final String EXCEPT_NONE_REGEXP = "(^(?!none).*|.{4}.+)";

    @Override
    @NotNull
    public List<EditorConfigOptionDescriptor> getOptionDescriptors() {
        if (!Utils.isFullIntellijSettingsSupport()) {
            return Collections.emptyList();
        }
        return IntellijConfigOptionDescriptorProvider.getAllOptions();
    }

    @Override
    public boolean requiresFullSupport() {
        return Utils.isFullIntellijSettingsSupport();
    }

    private static List<EditorConfigOptionDescriptor> getAllOptions() {
        ArrayList<EditorConfigOptionDescriptor> descriptors = new ArrayList<EditorConfigOptionDescriptor>();
        ArrayList mappers = new ArrayList();
        CodeStylePropertiesUtil.collectMappers((CodeStyleSettings)CodeStyle.getDefaultSettings(), mapper -> mappers.add(mapper));
        for (AbstractCodeStylePropertyMapper mapper2 : mappers) {
            for (String property : mapper2.enumProperties()) {
                EditorConfigDescriptor valueDescriptor;
                List<String> ecNames = IntellijConfigOptionDescriptorProvider.getEditorConfigNames(mapper2, property);
                if (ecNames.isEmpty() || (valueDescriptor = IntellijConfigOptionDescriptorProvider.createValueDescriptor(property, mapper2)) == null) continue;
                for (String ecName : ecNames) {
                    EditorConfigOptionDescriptor descriptor = new EditorConfigOptionDescriptor(new EditorConfigConstantDescriptor(ecName, mapper2.getPropertyDescription(property), null), valueDescriptor, null, null);
                    descriptors.add(descriptor);
                }
            }
        }
        return descriptors;
    }

    private static List<String> getEditorConfigNames(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String property) {
        if (EditorConfigIntellijNameUtil.isIndentProperty(property) && !(mapper instanceof GeneralCodeStylePropertyMapper)) {
            return Collections.singletonList(EditorConfigIntellijNameUtil.getLanguageProperty(mapper, property));
        }
        if (IntellijPropertyKindMap.getPropertyKind(property) == EditorConfigPropertyKind.EDITOR_CONFIG_STANDARD) {
            return Collections.emptyList();
        }
        return EditorConfigIntellijNameUtil.toEditorConfigNames(mapper, property);
    }

    @Nullable
    private static EditorConfigDescriptor createValueDescriptor(@NotNull String property, @NotNull AbstractCodeStylePropertyMapper mapper) {
        CodeStylePropertyAccessor accessor = mapper.getAccessor(property);
        if (accessor instanceof CodeStyleChoiceList) {
            return new EditorConfigUnionDescriptor(IntellijConfigOptionDescriptorProvider.choicesToDescriptorList((CodeStyleChoiceList)accessor), null, null);
        }
        if (accessor instanceof IntegerAccessor) {
            return new EditorConfigNumberDescriptor(null, null);
        }
        if (accessor instanceof ValueListPropertyAccessor) {
            return IntellijConfigOptionDescriptorProvider.createListDescriptor(new EditorConfigStringDescriptor(null, null, EXCEPT_NONE_REGEXP), ((ValueListPropertyAccessor)accessor).isEmptyListAllowed());
        }
        if (accessor instanceof ExternalStringAccessor) {
            return new EditorConfigStringDescriptor(null, null, ".*");
        }
        if (accessor instanceof VisualGuidesAccessor) {
            return IntellijConfigOptionDescriptorProvider.createListDescriptor(new EditorConfigNumberDescriptor(null, null), true);
        }
        return null;
    }

    @NotNull
    private static EditorConfigDescriptor createListDescriptor(@NotNull EditorConfigDescriptor childDescriptor, boolean canBeEmpty) {
        EditorConfigListDescriptor listDescriptor = new EditorConfigListDescriptor(0, true, Collections.singletonList(childDescriptor), null, null);
        if (canBeEmpty) {
            return new EditorConfigUnionDescriptor(Arrays.asList(listDescriptor, new EditorConfigConstantDescriptor("none", null, null)), null, null);
        }
        return listDescriptor;
    }

    private static List<EditorConfigDescriptor> choicesToDescriptorList(@NotNull CodeStyleChoiceList list) {
        return ContainerUtil.map((Collection)list.getChoices(), s -> new EditorConfigConstantDescriptor((String)s, null, null));
    }
}

