/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.CodeStyle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import javax.swing.Icon;
import org.editorconfig.configmanagement.EditorConfigActionUtil;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditorConfigCodeStyleStatusBarUIContributor
implements CodeStyleStatusBarUIContributor {
    EditorConfigCodeStyleStatusBarUIContributor() {
    }

    public boolean areActionsAvailable(@NotNull VirtualFile file) {
        return true;
    }

    public AnAction @Nullable [] getActions(@NotNull PsiFile file) {
        return EditorConfigActionUtil.createNavigationActions(file);
    }

    @Nullable
    public String getActionGroupTitle() {
        return EditorConfigBundle.message("action.group.title");
    }

    @Nullable
    public String getTooltip() {
        return EditorConfigBundle.message("config.code.style.overridden");
    }

    @Nullable
    public AnAction createDisableAction(@NotNull Project project) {
        return EditorConfigActionUtil.createDisableAction(project, EditorConfigBundle.message("action.disable"));
    }

    @NotNull
    public String getStatusText(@NotNull PsiFile psiFile) {
        CommonCodeStyleSettings.IndentOptions fileOptions = CodeStyle.getSettings((PsiFile)psiFile).getIndentOptionsByFile(psiFile);
        Object indentInfo = IndentStatusBarUIContributor.getIndentInfo((CommonCodeStyleSettings.IndentOptions)fileOptions);
        CommonCodeStyleSettings.IndentOptions projectOptions = CodeStyle.getSettings((Project)psiFile.getProject()).getIndentOptions(psiFile.getFileType());
        if (projectOptions.INDENT_SIZE != fileOptions.INDENT_SIZE || projectOptions.USE_TAB_CHARACTER != fileOptions.USE_TAB_CHARACTER) {
            indentInfo = (String)indentInfo + "*";
        }
        return indentInfo;
    }

    @Nullable
    public AnAction createShowAllAction(@NotNull Project project) {
        return EditorConfigActionUtil.createShowEditorConfigFilesAction();
    }

    public Icon getIcon() {
        return AllIcons.Ide.ConfigFile;
    }
}

