/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.codeStyle.cache.CodeStyleCachingService;
import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertiesUtil;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.GeneralCodeStylePropertyMapper;
import com.intellij.ide.impl.ProjectUtilKt;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.util.ObjectUtils;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigFilesCollector;
import org.editorconfig.configmanagement.EditorConfigNavigationActionsFactory;
import org.editorconfig.configmanagement.EditorConfigUsagesCollector;
import org.editorconfig.configmanagement.extended.EditorConfigCodeStyleStatusBarUIContributor;
import org.editorconfig.configmanagement.extended.EditorConfigIntellijNameUtil;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.editorconfig.configmanagement.extended.IntellijPropertyKindMap;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.core.EditorConfigException;
import org.editorconfig.core.ParsingException;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class EditorConfigCodeStyleSettingsModifier
implements CodeStyleSettingsModifier {
    private static final Logger LOG = Logger.getInstance(EditorConfigCodeStyleSettingsModifier.class);
    private static final Duration TIMEOUT = Duration.ofSeconds(10L);
    private static boolean ourEnabledInTests;
    private final Set<String> myReportedErrorIds = new HashSet<String>();

    public boolean modifySettings(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile psiFile) {
        Project project;
        VirtualFile file = psiFile.getVirtualFile();
        if (Utils.isFullIntellijSettingsSupport() && file != null && (!ApplicationManager.getApplication().isUnitTestMode() || EditorConfigCodeStyleSettingsModifier.isEnabledInTests()) && !(project = psiFile.getProject()).isDisposed() && Utils.isEnabled((CodeStyleSettings)settings)) {
            try {
                MyContext context = new MyContext((CodeStyleSettings)settings, psiFile);
                return EditorConfigCodeStyleSettingsModifier.runWithTimeout(project, () -> {
                    EditorConfigCodeStyleSettingsModifier.processEditorConfig(project, psiFile, context);
                    if (EditorConfigCodeStyleSettingsModifier.applyCodeStyleSettings(context)) {
                        settings.addDependencies(context.getEditorConfigFiles());
                        EditorConfigNavigationActionsFactory navigationFactory = EditorConfigNavigationActionsFactory.getInstance(psiFile);
                        if (navigationFactory != null) {
                            navigationFactory.updateEditorConfigFilePaths(context.getFilePaths());
                        }
                        return true;
                    }
                    return false;
                });
            }
            catch (TimeoutException toe) {
                StackTraceElement[] trace = (StackTraceElement[])psiFile.getUserData(CodeStyleCachingService.CALL_TRACE);
                StringBuilder messageBuilder = new StringBuilder();
                if (trace != null) {
                    messageBuilder.append("Timeout which searching .editorconfig for ").append(file.getName()).append("\n        at ");
                    messageBuilder.append(Arrays.stream(trace).skip(1L).limit(15L).map(e -> e.toString()).collect(Collectors.joining("\n        at ")));
                    LOG.warn(messageBuilder.toString());
                } else {
                    LOG.warn((Throwable)toe);
                }
                if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    this.error(project, "timeout", EditorConfigBundle.message("error.timeout"), new DisableEditorConfigAction(project), true);
                }
            }
            catch (EditorConfigException toe) {
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
        return false;
    }

    private static boolean runWithTimeout(@NotNull Project project, @NotNull Callable<Boolean> callable) throws TimeoutException, EditorConfigException {
        CompletableFuture future = ProjectUtilKt.computeOnPooledThread((Project)project, callable);
        try {
            return (Boolean)future.get(TIMEOUT.toSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EditorConfigException) {
                throw (EditorConfigException)e.getCause();
            }
            LOG.error((Throwable)e);
        }
        return false;
    }

    public synchronized void error(Project project, final String id, @Nls String message2, final @Nullable AnAction fixAction, boolean oneTime) {
        if (oneTime) {
            if (this.myReportedErrorIds.contains(id)) {
                return;
            }
            this.myReportedErrorIds.add(id);
        }
        final Notification notification = new Notification("editorconfig", EditorConfigBundle.message("editorconfig"), message2, NotificationType.ERROR);
        if (fixAction != null) {
            notification.addAction(new AnAction(fixAction.getTemplateText()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    fixAction.actionPerformed(e);
                    EditorConfigCodeStyleSettingsModifier.this.myReportedErrorIds.remove(id);
                    notification.expire();
                }
            });
        }
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    @NotNull
    public CodeStyleStatusBarUIContributor getStatusBarUiContributor(@NotNull TransientCodeStyleSettings transientSettings) {
        return new EditorConfigCodeStyleStatusBarUIContributor();
    }

    private static boolean applyCodeStyleSettings(@NotNull MyContext context) {
        HashSet<String> processed = new HashSet<String>();
        boolean isModified = false;
        for (AbstractCodeStylePropertyMapper mapper : EditorConfigCodeStyleSettingsModifier.getMappers(context)) {
            processed.clear();
            isModified |= EditorConfigCodeStyleSettingsModifier.processOptions(context, mapper, false, processed);
            isModified |= EditorConfigCodeStyleSettingsModifier.processOptions(context, mapper, true, processed);
        }
        if (isModified) {
            ObjectUtils.consumeIfNotNull(context.myOptions, options -> EditorConfigUsagesCollector.logEditorConfigUsed(context.myFile, options));
        }
        return isModified;
    }

    public boolean mayOverrideSettingsOf(@NotNull Project project) {
        return Utils.isEnabled(CodeStyle.getSettings((Project)project)) && Utils.editorConfigExists(project);
    }

    public String getName() {
        return EditorConfigBundle.message("editorconfig");
    }

    private static boolean processOptions(@NotNull MyContext context, @NotNull AbstractCodeStylePropertyMapper mapper, boolean languageSpecific, Set<String> processed) {
        String langPrefix = languageSpecific ? mapper.getLanguageDomainId() + "_" : null;
        boolean isModified = false;
        for (EditorConfig.OutPair option : context.getOptions()) {
            String optionKey = option.getKey();
            String intellijName = EditorConfigIntellijNameUtil.toIntellijName(optionKey);
            CodeStylePropertyAccessor<?> accessor = EditorConfigCodeStyleSettingsModifier.findAccessor(mapper, intellijName, langPrefix);
            if (accessor == null) continue;
            String val = EditorConfigCodeStyleSettingsModifier.preprocessValue(accessor, context, optionKey, option.getVal());
            for (String dependency : EditorConfigCodeStyleSettingsModifier.getDependentProperties(optionKey, langPrefix)) {
                CodeStylePropertyAccessor<?> dependencyAccessor;
                if (processed.contains(dependency) || (dependencyAccessor = EditorConfigCodeStyleSettingsModifier.findAccessor(mapper, dependency, null)) == null) continue;
                isModified |= dependencyAccessor.setFromString(val);
            }
            isModified |= accessor.setFromString(val);
            processed.add(intellijName);
        }
        return isModified;
    }

    @NotNull
    private static List<String> getDependentProperties(@NotNull String property, @Nullable String langPrefix) {
        property = Strings.trimStart((String)property, (String)"ij_");
        if (langPrefix != null && property.startsWith(langPrefix)) {
            property = Strings.trimStart((String)property, (String)langPrefix);
        }
        if ("indent_size".equals(property)) {
            return Collections.singletonList("continuation_indent_size");
        }
        return Collections.emptyList();
    }

    private static String preprocessValue(@NotNull CodeStylePropertyAccessor<?> accessor, @NotNull MyContext context, @NotNull String optionKey, @NotNull String optionValue) {
        if ("indent_size".equals(optionKey)) {
            String explicitTabSize = context.getExplicitTabSize();
            if ("tab".equals(optionValue)) {
                return (String)ObjectUtils.notNull((Object)explicitTabSize, (Object)context.getDefaultTabSize());
            }
            if (context.isTabIndent() && explicitTabSize != null) {
                return explicitTabSize;
            }
        } else if ("none".equals(optionValue) && CodeStylePropertiesUtil.isAccessorAllowingEmptyList(accessor)) {
            return "";
        }
        return optionValue;
    }

    @Nullable
    private static CodeStylePropertyAccessor<?> findAccessor(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String propertyName, @Nullable String langPrefix) {
        if (langPrefix != null) {
            String prefixlessName;
            EditorConfigPropertyKind propertyKind;
            if (propertyName.startsWith(langPrefix) && ((propertyKind = IntellijPropertyKindMap.getPropertyKind(prefixlessName = Strings.trimStart((String)propertyName, (String)langPrefix))) == EditorConfigPropertyKind.LANGUAGE || propertyKind == EditorConfigPropertyKind.COMMON || EditorConfigIntellijNameUtil.isIndentProperty(prefixlessName))) {
                return mapper.getAccessor(prefixlessName);
            }
        } else {
            return mapper.getAccessor(propertyName);
        }
        return null;
    }

    private static void processEditorConfig(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull MyContext context) throws EditorConfigException {
        try {
            VirtualFile file = psiFile.getVirtualFile();
            String filePath = Utils.getFilePath(project, file);
            if (filePath != null) {
                Set<String> rootDirs = SettingsProviderComponent.getInstance().getRootDirs(project);
                context.setOptions(new EditorConfig().getProperties(filePath, rootDirs, context));
            } else if (VfsUtilCore.isBrokenLink((VirtualFile)file)) {
                LOG.warn(file.getPresentableUrl() + " is a broken link");
            }
        }
        catch (ParsingException pe) {
            LOG.debug((Throwable)pe);
        }
    }

    @NotNull
    public Consumer<CodeStyleSettings> getDisablingFunction(@NotNull Project project) {
        return settings -> {
            EditorConfigSettings editorConfigSettings = (EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class);
            editorConfigSettings.ENABLED = false;
        };
    }

    private static boolean isEnabledInTests() {
        return ourEnabledInTests;
    }

    @TestOnly
    public static void setEnabledInTests(boolean isEnabledInTests) {
        ourEnabledInTests = isEnabledInTests;
    }

    private static Collection<AbstractCodeStylePropertyMapper> getMappers(@NotNull MyContext context) {
        HashSet<AbstractCodeStylePropertyMapper> mappers = new HashSet<AbstractCodeStylePropertyMapper>();
        for (LanguageCodeStyleSettingsProvider provider : EditorConfigCodeStyleSettingsModifier.getLanguageCodeStyleProviders(context)) {
            mappers.add(provider.getPropertyMapper(context.getSettings()));
        }
        mappers.add((AbstractCodeStylePropertyMapper)new GeneralCodeStylePropertyMapper(context.getSettings()));
        return mappers;
    }

    private static Collection<LanguageCodeStyleSettingsProvider> getLanguageCodeStyleProviders(@NotNull MyContext context) {
        HashSet<LanguageCodeStyleSettingsProvider> providers = new HashSet<LanguageCodeStyleSettingsProvider>();
        LanguageCodeStyleSettingsProvider mainProvider = LanguageCodeStyleSettingsProvider.findUsingBaseLanguage((Language)context.getLanguage());
        if (mainProvider != null) {
            providers.add(mainProvider);
        }
        for (String langId : EditorConfigCodeStyleSettingsModifier.getLanguageIds(context)) {
            if (!langId.equals("any")) {
                LanguageCodeStyleSettingsProvider additionalProvider = LanguageCodeStyleSettingsProvider.findByExternalLanguageId((String)langId);
                if (additionalProvider == null) continue;
                providers.add(additionalProvider);
                continue;
            }
            providers.clear();
            providers.addAll(LanguageCodeStyleSettingsProvider.getAllProviders());
            break;
        }
        return providers;
    }

    @NotNull
    private static Collection<String> getLanguageIds(@NotNull MyContext context) {
        HashSet<String> langIds = new HashSet<String>();
        for (EditorConfig.OutPair option : context.getOptions()) {
            String langId;
            String key = option.getKey();
            if (EditorConfigIntellijNameUtil.isIndentProperty(key)) {
                langIds.add("any");
            }
            if ((langId = EditorConfigIntellijNameUtil.extractLanguageDomainId(key)) == null) continue;
            langIds.add(langId);
        }
        return langIds;
    }

    private static final class MyContext
    extends EditorConfigFilesCollector {
        @NotNull
        private final CodeStyleSettings mySettings;
        @Nullable
        private List<EditorConfig.OutPair> myOptions;
        @NotNull
        private final PsiFile myFile;

        private MyContext(@NotNull CodeStyleSettings settings, @NotNull PsiFile file) {
            this.mySettings = settings;
            this.myFile = file;
        }

        public void setOptions(@NotNull List<EditorConfig.OutPair> options) {
            this.myOptions = options;
        }

        @NotNull
        private CodeStyleSettings getSettings() {
            return this.mySettings;
        }

        @NotNull
        private List<EditorConfig.OutPair> getOptions() {
            return this.myOptions == null ? Collections.emptyList() : this.myOptions;
        }

        @NotNull
        private Language getLanguage() {
            return this.myFile.getLanguage();
        }

        @NotNull
        private String getDefaultTabSize() {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.mySettings.getIndentOptions(this.myFile.getFileType());
            return String.valueOf(indentOptions.TAB_SIZE);
        }

        @Nullable
        private String getExplicitTabSize() {
            for (EditorConfig.OutPair pair : this.getOptions()) {
                if (!"tab_width".equals(pair.getKey())) continue;
                return pair.getVal();
            }
            return null;
        }

        private boolean isTabIndent() {
            for (EditorConfig.OutPair pair : this.getOptions()) {
                if (!"indent_style".equals(pair.getKey())) continue;
                return "tab".equals(pair.getVal());
            }
            return false;
        }
    }

    private static class DisableEditorConfigAction
    extends AnAction {
        private final Project myProject;

        private DisableEditorConfigAction(Project project) {
            super(EditorConfigBundle.message("action.disable"));
            this.myProject = project;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            EditorConfigSettings editorConfigSettings = (EditorConfigSettings)CodeStyle.getSettings((Project)this.myProject).getCustomSettings(EditorConfigSettings.class);
            editorConfigSettings.ENABLED = false;
            CodeStyleSettingsManager.getInstance((Project)this.myProject).notifyCodeStyleSettingsChanged();
        }
    }
}

