/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.ConfigEncodingManager;
import org.editorconfig.configmanagement.EditorConfigEncodingCache;
import org.editorconfig.language.psi.EditorConfigOption;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;

public final class EditorConfigStatusListener
implements CodeStyleSettingsListener,
Disposable {
    private boolean myEnabledStatus;
    private final VirtualFile myVirtualFile;
    private final Project myProject;
    private Set<String> myEncodings;

    public EditorConfigStatusListener(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        this.myProject = project;
        this.myEnabledStatus = Utils.isEnabled(project);
        this.myVirtualFile = virtualFile;
        this.myEncodings = this.extractEncodings();
        CodeStyleSettingsManager.getInstance((Project)project).addListener((CodeStyleSettingsListener)this);
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        Set<String> newEncodings;
        CodeStyleSettings settings = CodeStyle.getSettings((Project)this.myProject);
        if (settings.getCustomSettingsIfCreated(EditorConfigSettings.class) == null) {
            return;
        }
        boolean newEnabledStatus = Utils.isEnabled(this.myProject);
        if (this.myEnabledStatus != newEnabledStatus) {
            this.myEnabledStatus = newEnabledStatus;
            this.onEditorConfigEnabled(newEnabledStatus);
        }
        if (!this.myEncodings.equals(newEncodings = this.extractEncodings())) {
            if (EditorConfigStatusListener.containsValidEncodings(newEncodings)) {
                EditorConfigStatusListener.onEncodingChanged();
            }
            this.myEncodings = newEncodings;
        }
    }

    private void onEditorConfigEnabled(boolean isEnabled) {
        PsiFile psiFile;
        if (!isEnabled) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
            fileEditorManager.closeFile(this.myVirtualFile);
            fileEditorManager.openFile(this.myVirtualFile, false);
        }
        EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myVirtualFile);
        Document document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
        PsiFile psiFile2 = psiFile = document == null ? null : PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(psiFile);
        }
    }

    public void dispose() {
        CodeStyleSettingsManager.removeListener((Project)this.myProject, (CodeStyleSettingsListener)this);
    }

    private static void onEncodingChanged() {
        EditorConfigEncodingCache.getInstance().reset();
    }

    private static boolean containsValidEncodings(@NotNull Set<String> encodings) {
        return ContainerUtil.and(encodings, encoding -> ConfigEncodingManager.toCharset(encoding) != null);
    }

    @NotNull
    private Set<String> extractEncodings() {
        final HashSet<String> charsets = new HashSet<String>();
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myVirtualFile);
        if (psiFile != null) {
            PsiRecursiveElementVisitor visitor2 = new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    String charsetStr;
                    String keyName;
                    if (element instanceof PsiFile || element instanceof EditorConfigSection) {
                        super.visitElement(element);
                    } else if (element instanceof EditorConfigOption && "charset".equals(keyName = (String)ObjectUtils.doIfNotNull((Object)((EditorConfigOption)element).getFlatOptionKey(), NavigationItem::getName)) && (charsetStr = (String)ObjectUtils.doIfNotNull((Object)((EditorConfigOption)element).getOptionValueIdentifier(), NavigationItem::getName)) != null) {
                        charsets.add(charsetStr);
                    }
                }
            };
            psiFile.accept((PsiElementVisitor)visitor2);
        }
        return charsets;
    }
}

