/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.CharUtils;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EditorConfigPreviewManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class EditorConfigPreviewManager
implements PersistentStateComponent<Element> {
    private final Map<String, String> myPreviewMap = new HashMap<String, String>();
    public static final String PREVIEW_RECORD_TAG = "editorConfig";
    public static final String EDITORCONFIG_FILE_ATTR = "file";
    public static final String PREVIEW_FILE_ATTR = "previewFile";

    @Nullable
    public Element getState() {
        Element state = new Element("previewData");
        for (String key : this.myPreviewMap.keySet()) {
            String value = this.myPreviewMap.get(key);
            if (value == null) continue;
            Element previewRec = new Element(PREVIEW_RECORD_TAG);
            previewRec.setAttribute(EDITORCONFIG_FILE_ATTR, key);
            previewRec.setAttribute(PREVIEW_FILE_ATTR, value);
            state.addContent(previewRec);
        }
        return state;
    }

    public void loadState(@NotNull Element state) {
        for (Element previewRec : state.getChildren(PREVIEW_RECORD_TAG)) {
            String key = previewRec.getAttributeValue(EDITORCONFIG_FILE_ATTR);
            String value = previewRec.getAttributeValue(PREVIEW_FILE_ATTR);
            if (key == null || value == null) continue;
            this.myPreviewMap.put(key, value);
        }
    }

    public static EditorConfigPreviewManager getInstance(@NotNull Project project) {
        return (EditorConfigPreviewManager)project.getService(EditorConfigPreviewManager.class);
    }

    @NotNull
    static List<String> extractExtensions(@NotNull EditorConfigHeader header) {
        ArrayList<String> extensions = new ArrayList<String>();
        CharSequence headerChars = header.getNode().getChars();
        boolean isInExt = false;
        StringBuilder extBuilder = new StringBuilder();
        for (int i = 0; i < headerChars.length(); ++i) {
            char c = headerChars.charAt(i);
            if (c == '.') {
                isInExt = true;
                continue;
            }
            if ((CharUtils.isAsciiAlpha((char)c) || CharUtils.isAsciiNumeric((char)c)) && isInExt) {
                extBuilder.append(c);
                continue;
            }
            if (isInExt && extBuilder.length() > 0) {
                extensions.add(extBuilder.toString());
                extBuilder = new StringBuilder();
            }
            isInExt = false;
        }
        return extensions;
    }

    public void associateWithPreviewFile(@NotNull VirtualFile editorConfigFile, @Nullable VirtualFile previewFile) {
        if (previewFile != null) {
            this.myPreviewMap.put(editorConfigFile.getPath(), previewFile.getPath());
        } else {
            this.myPreviewMap.remove(editorConfigFile.getPath());
        }
    }

    @Nullable
    public VirtualFile getAssociatedPreviewFile(@NotNull VirtualFile editorConfigFile) {
        String editorConfigFilePath = editorConfigFile.getPath();
        String previewPathStr = this.myPreviewMap.get(editorConfigFilePath);
        if (previewPathStr != null) {
            Path previewPath = Paths.get(previewPathStr, new String[0]);
            VirtualFile actualFile = VfsUtil.findFile((Path)previewPath, (boolean)true);
            if (actualFile == null) {
                this.myPreviewMap.remove(editorConfigFilePath);
            }
            return actualFile;
        }
        return null;
    }
}

